/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfErrorAction;
import com.atlassian.jira.security.xsrf.XsrfFailureException;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.seraph.util.RedirectUtils;
import java.beans.Introspector;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;
import webwork.action.ResultException;
import webwork.config.Configuration;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.MultiPartRequestWrapper;
import webwork.util.ServletValueStack;
import webwork.util.ValueStack;

public class JiraWebworkActionDispatcher
extends HttpServlet {
    private static final Logger log = Logger.getLogger(JiraWebworkActionDispatcher.class);
    public static final String STACK_HEAD = "webwork.valuestack.head";
    public static final String GD = "jira.webwork.generic.dispatcher";
    public static final String CLEANUP = "jira.webwork.cleanup";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ACTION_EXTENSION = ".jspa";
    private String saveDir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (JiraStartupChecklist.startupOK()) {
            Introspector.flushCaches();
            ValueStack.clearMethods();
            File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
            if (tempdir != null) {
                this.saveDir = tempdir.getAbsolutePath();
            } else {
                log.error((Object)"Servlet Context Temp Directory isn't set. No save directory set for file uploads.");
            }
            log.info((Object)("Setting Upload File Directory to '" + this.saveDir + "'"));
            log.info((Object)"JiraWebworkActionDispatcher initialized");
        } else {
            String message = "JIRA startup failed, JIRA has been locked.";
            String line = StringUtils.repeat((String)"*", (int)message.length());
            log.fatal((Object)(NEW_LINE + NEW_LINE + line + NEW_LINE + message + NEW_LINE + line + NEW_LINE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        boolean doCleanup = (httpServletRequest = this.wrapRequest(httpServletRequest)).getAttribute(CLEANUP) == null || httpServletRequest.getAttribute(CLEANUP).equals(Boolean.TRUE);
        GenericDispatcher gd = null;
        try {
            String actionName = this.getActionName(httpServletRequest);
            gd = this.prepareDispatcher(httpServletRequest, httpServletResponse, actionName);
            ActionResult ar = null;
            try {
                gd.executeAction();
                ar = gd.finish();
            }
            catch (XsrfFailureException e) {
                ActionContext.getValueStack().pushValue((Object)new XsrfErrorAction(e));
                ar = new ActionResult("error", (Object)"/secure/security/xsrf/xsrf.jsp", Collections.EMPTY_LIST, null);
            }
            catch (WebSudoSessionException websudoException) {
                ar = new ActionResult("login", (Object)("/secure/admin/WebSudoAuthenticate!default.jspa?webSudoDestination=" + JiraUrlCodec.encode(httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() == null ? "" : httpServletRequest.getPathInfo()) + (httpServletRequest.getQueryString() == null ? "" : "?" + httpServletRequest.getQueryString()))), Collections.EMPTY_LIST, null);
            }
            catch (Throwable e) {
                this.onActionThrowable(httpServletResponse, actionName, e);
            }
            if (ar != null && ar.getActionException() != null) {
                this.onActionException(ar);
            }
            if (ar != null && ar.getResult() != null && ar.getView() == null && !ar.getResult().equals("none")) {
                this.onNoViewDefined(httpServletResponse, actionName, ar);
            }
            if (ar != null && ar.getView() != null && ar.getActionException() == null) {
                this.dispatchView(httpServletRequest, httpServletResponse, doCleanup, ar);
            }
            this.performFinallyCleanup(httpServletRequest, doCleanup, gd);
        }
        catch (Throwable throwable) {
            this.performFinallyCleanup(httpServletRequest, doCleanup, gd);
            throw throwable;
        }
    }

    private GenericDispatcher prepareDispatcher(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String actionName) {
        GenericDispatcher gd = new GenericDispatcher(actionName, false);
        gd.prepareContext();
        ActionContextKit.setContext(httpServletRequest, httpServletResponse, this.getServletContext(), actionName);
        gd.prepareValueStack();
        return gd;
    }

    private void onActionException(ActionResult ar) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Could not execute action", (Throwable)ar.getActionException());
        }
        throw new ServletException((Throwable)ar.getActionException());
    }

    private void onActionThrowable(HttpServletResponse httpServletResponse, String actionName, Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Could not execute action : ", e);
        }
        this.sendErrorImpl(httpServletResponse, 404, "Could not execute action [" + actionName + "]:" + e.getMessage() + this.getHTMLErrorMessage(e));
    }

    private void onNoViewDefined(HttpServletResponse httpServletResponse, String actionName, ActionResult ar) {
        this.sendErrorImpl(httpServletResponse, 404, "No view for result [" + ar.getResult() + "] exists for action [" + actionName + "]");
    }

    private void sendErrorImpl(HttpServletResponse httpServletResponse, int statusCode, String msg) {
        try {
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(statusCode, msg);
            }
        }
        catch (IOException e1) {
            log.error((Object)("Error occurred while sending error response : " + statusCode + " - " + msg + " because of" + e1.getMessage()));
        }
    }

    private void dispatchView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean doCleanup, ActionResult ar) throws ServletException {
        if (this.permissionViolationCheckHandled(ar, httpServletRequest, httpServletResponse, doCleanup)) {
            return;
        }
        String view = ar.getView().toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result:" + view));
        }
        RequestDispatcher dispatcher = null;
        try {
            dispatcher = httpServletRequest.getRequestDispatcher(view);
        }
        catch (Throwable e) {
            log.error((Object)("Error while dispatching request for view '" + view + "'."), e);
        }
        if (dispatcher == null) {
            throw new ServletException("No presentation file with name '" + view + "' found!");
        }
        try {
            if (httpServletRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
                httpServletRequest.setAttribute("webwork.view_uri", (Object)view);
                httpServletRequest.setAttribute("webwork.request_uri", (Object)httpServletRequest.getRequestURI());
                dispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                dispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this.cleanUpStack(httpServletRequest, doCleanup);
        }
    }

    private void cleanUpStack(HttpServletRequest httpServletRequest, boolean doCleanup) {
        if (doCleanup) {
            httpServletRequest.setAttribute(STACK_HEAD, ServletValueStack.getStack((ServletRequest)httpServletRequest).popValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean permissionViolationCheckHandled(ActionResult ar, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean doCleanup) {
        String result;
        if (!this.isUserLoggedIn() && ("permissionviolation".equals(result = ar.getResult()) || "securitybreach".equals(result))) {
            String loginUrl = RedirectUtils.getLoginUrl((HttpServletRequest)httpServletRequest);
            try {
                httpServletResponse.sendRedirect(loginUrl);
            }
            catch (IOException e) {
                log.error((Object)("Unable to redirect permission violation to " + loginUrl));
            }
            finally {
                this.cleanUpStack(httpServletRequest, doCleanup);
            }
            return true;
        }
        return false;
    }

    private void performFinallyCleanup(HttpServletRequest httpServletRequest, boolean doCleanup, GenericDispatcher gd) {
        if (doCleanup) {
            if (gd != null) {
                gd.finalizeContext();
            }
        } else {
            httpServletRequest.setAttribute(GD, (Object)gd);
        }
    }

    private String getActionName(HttpServletRequest httpServletRequest) {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        int beginIdx = servletPath.lastIndexOf("/");
        int endIdx = servletPath.lastIndexOf(ACTION_EXTENSION);
        return servletPath.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? servletPath.length() : endIdx);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest httpServletRequest) {
        if (httpServletRequest instanceof MultiPartRequestWrapper) {
            return httpServletRequest;
        }
        String disableMultipartGetString = this.multipartDisableGetString();
        boolean disableMultipartGet = Boolean.valueOf(disableMultipartGetString);
        if (this.needsMultipartWrapper(httpServletRequest, disableMultipartGet)) {
            try {
                httpServletRequest = new MultiPartRequestWrapper(httpServletRequest, this.saveDir, this.getMaxSize());
            }
            catch (IOException e) {
                httpServletRequest.setAttribute("webwork.action.ResultException", (Object)new ResultException("error", e.getLocalizedMessage()));
            }
        }
        return httpServletRequest;
    }

    private String multipartDisableGetString() {
        return ComponentAccessor.getApplicationProperties().getDefaultString("jira.disable.multipart.get.http.request");
    }

    private boolean needsMultipartWrapper(HttpServletRequest httpServletRequest, boolean disableMultipartGet) {
        return MultiPartRequest.isMultiPart((HttpServletRequest)httpServletRequest) && ("POST".equals(httpServletRequest.getMethod()) || "GET".equals(httpServletRequest.getMethod()) && !disableMultipartGet);
    }

    protected String getHTMLErrorMessage(Throwable t) {
        return "<p><small><small><pre>" + JiraWebworkActionDispatcher.getStackTrace(t) + "</pre></small></small></p>";
    }

    private static String getStackTrace(Throwable t) {
        CharArrayWriter sink = new CharArrayWriter(400);
        PrintWriter exceptionWriter = new PrintWriter(sink);
        t.printStackTrace(exceptionWriter);
        return sink.toString();
    }

    private Integer getMaxSize() {
        Integer maxSize;
        try {
            String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    maxSize = Integer.MAX_VALUE;
                    log.warn((Object)("Property 'webwork.multipart.maxSize' with value '" + maxSizeStr + "' is not a number. Defaulting to Integer.MAX_VALUE"));
                }
            } else {
                maxSize = Integer.MAX_VALUE;
                log.warn((Object)"Property 'webwork.multipart.maxSize' is not set. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            maxSize = Integer.MAX_VALUE;
            log.warn((Object)"Failed getting string from Configuration for 'webwork.multipart.maxSize' property. Defaulting to Integer.MAX_VALUE", (Throwable)e1);
        }
        return maxSize;
    }

    public boolean isUserLoggedIn() {
        return ComponentManager.getComponent(JiraAuthenticationContext.class).getLoggedInUser() != null;
    }
}

