/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.webfragment;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.webfragment.ContextLayoutBean;
import com.atlassian.jira.web.util.AccessKeyHelperImpl;
import com.atlassian.velocity.VelocityManager;
import java.util.List;
import java.util.Map;

public class WebFragmentWebComponent
extends AbstractWebComponent {
    private final JiraWebInterfaceManager webInterfaceManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SimpleLinkManager simpleLinkManager;

    public WebFragmentWebComponent(JiraWebInterfaceManager webInterfaceManager, VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, SimpleLinkManager simpleLinkManager) {
        super(velocityManager, applicationProperties);
        this.webInterfaceManager = webInterfaceManager;
        this.authenticationContext = authenticationContext;
        this.simpleLinkManager = simpleLinkManager;
    }

    public String getHtml(String template, String location, JiraHelper jiraHelper) {
        return this.getHtml(template, location, jiraHelper, null);
    }

    public String getHtml(String template, String location, JiraHelper jiraHelper, ContextLayoutBean layoutBean) {
        return this.getHtml(template, this.getDefaultParams(this.makeContext(location, this.authenticationContext.getLoggedInUser(), jiraHelper, layoutBean, this.authenticationContext.getI18nHelper())));
    }

    private Map<String, Object> makeContext(String location, User remoteUser, JiraHelper jiraHelper, ContextLayoutBean layoutBean, I18nHelper i18n) {
        return MapBuilder.newBuilder("webInterfaceManager", this.webInterfaceManager).add("linkManager", (JiraWebInterfaceManager)((Object)this.simpleLinkManager)).add("location", (JiraWebInterfaceManager)((Object)location)).add("user", (JiraWebInterfaceManager)remoteUser).add("helper", (JiraWebInterfaceManager)((Object)jiraHelper)).add("i18n", (JiraWebInterfaceManager)((Object)i18n)).add("accessKeyHelper", (JiraWebInterfaceManager)((Object)new AccessKeyHelperImpl())).add("layout", (JiraWebInterfaceManager)((Object)layoutBean)).toMap();
    }

    private Map<String, Object> getDefaultParams(Map<String, Object> startingParams) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
    }

    public boolean hasDisplayableItems(String location, JiraHelper jiraHelper) {
        User remoteUser = this.authenticationContext.getLoggedInUser();
        if (!this.simpleLinkManager.getLinksForSection(location, remoteUser, jiraHelper).isEmpty()) {
            return true;
        }
        List<SimpleLinkSection> displayableSections = this.simpleLinkManager.getSectionsForLocation(location, remoteUser, jiraHelper);
        for (SimpleLinkSection section : displayableSections) {
            if (this.simpleLinkManager.getLinksForSection(location + "/" + section.getId(), remoteUser, jiraHelper).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

