/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import com.atlassian.velocity.VelocityManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class ActionsAndOperationsColumnLayoutItem
extends SimpleColumnLayoutItem {
    private static final Logger log = Logger.getLogger(ActionsAndOperationsColumnLayoutItem.class);
    private static final String SUBTASK_OPERATION_TEMPLATE = "issue-operations.vm";
    private static final String CSS_CLASS = "issue_actions";
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/jira/issue/field/";
    private final VelocityManager velocityManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final XsrfTokenGenerator xsrfTokenGenerator;

    public ActionsAndOperationsColumnLayoutItem(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, XsrfTokenGenerator xsrfTokenGenerator) {
        this.velocityManager = velocityManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    @Override
    protected String getColumnCssClass() {
        return CSS_CLASS;
    }

    @Override
    public String getHtml(Map displayParams, Issue issue) {
        HashMap<String, Object> localParams = new HashMap<String, Object>();
        localParams.put("issue", issue);
        localParams.put("atl_token", this.xsrfTokenGenerator.generateToken());
        localParams.put("displayParams", displayParams);
        localParams.put("i18n", this.authenticationContext.getI18nHelper());
        Map<String, Object> velocityParams = CompositeMap.of(localParams, JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext));
        try {
            return this.velocityManager.getEncodedBody(TEMPLATE_DIRECTORY_PATH, SUBTASK_OPERATION_TEMPLATE, this.applicationProperties.getEncoding(), velocityParams);
        }
        catch (VelocityException e) {
            log.error((Object)"Error occurred while rendering velocity template for 'templates/jira/issue/field//issue-operations.vm'.", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getColumnHeadingKey() {
        return "";
    }
}

