/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.cron.generator;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.google.common.collect.ImmutableMap;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CronExpressionDescriptor {
    private static final Map<String, String> MINUTE_INCREMENT_TO_MESG_KEY = ImmutableMap.of((Object)"15", (Object)"cron.editor.every.15.minutes", (Object)"30", (Object)"cron.editor.every.30.minutes", (Object)"60", (Object)"cron.editor.every.hour", (Object)"120", (Object)"cron.editor.every.2.hours", (Object)"180", (Object)"cron.editor.every.3.hours");
    private static final Map<String, String> DAY_NUMBERS;
    private static final String CRON_EDITOR_KEY_PREFIX = "cron.editor.";
    private static final int MINUTES_DIGITS = 2;
    private static final int DAYS_IN_WEEK = 7;
    private static final String LAST_COMMA_REGEX = ",([^,]*)$";
    private final I18nHelper i18n;

    public CronExpressionDescriptor(I18nHelper i18n) {
        this.i18n = i18n;
    }

    private String getDay(String number) {
        String keypart = DAY_NUMBERS.get(number);
        return this.i18n.getText(CRON_EDITOR_KEY_PREFIX + keypart);
    }

    public String getPrettySchedule(CronEditorBean bean) {
        if (bean.isAdvancedMode()) {
            return bean.getCronString();
        }
        StringBuffer desc = new StringBuffer();
        if (bean.isDailyMode()) {
            desc.append(this.i18n.getText("cron.editor.daily")).append(" ");
            desc.append(this.getTimePart(bean));
        } else if (bean.isDayPerWeekMode()) {
            desc.append(this.getDayPerWeekDescriptor(bean));
        } else if (bean.isDaysPerMonthMode()) {
            desc.append(this.getDayPerMonthDescriptor(bean));
        }
        return desc.toString();
    }

    private String getDayPerWeekDescriptor(CronEditorBean bean) {
        StringBuffer desc = new StringBuffer();
        desc.append(this.i18n.getText("cron.editor.each"));
        desc.append(" ");
        Object[] daysArray = bean.getSpecifiedDaysPerWeek().split(",");
        Arrays.sort(daysArray);
        String daysString = StringUtils.join((Object[])daysArray, (String)",");
        daysString = daysString.replaceAll(LAST_COMMA_REGEX, " and $1");
        for (int i = 1; i <= 7; ++i) {
            String dayNum = Integer.toString(i);
            daysString = daysString.replaceAll(dayNum, this.getDay(dayNum));
        }
        daysString = daysString.replaceAll(",", ", ");
        desc.append(daysString).append(" ");
        desc.append(this.getTimePart(bean));
        return desc.toString();
    }

    private String getDayPerMonthDescriptor(CronEditorBean bean) {
        StringBuffer desc = new StringBuffer();
        if (bean.isDayOfWeekOfMonth()) {
            String ordinal = this.i18n.getText("cron.editor.ordinal." + bean.getDayInMonthOrdinal());
            String ordinalWeekday = ordinal + " " + this.getDay(bean.getSpecifiedDaysPerWeek());
            desc.append(this.i18n.getText("cron.editor.the.of.every.month", ordinalWeekday));
            desc.append(" ");
            desc.append(this.getTimePart(bean));
        } else {
            desc.append(this.i18n.getText("cron.editor.the.day.of.every.month", this.i18n.getText("cron.editor.nth." + bean.getDayOfMonth())));
            desc.append(" ");
            desc.append(this.getTimePart(bean));
        }
        return desc.toString();
    }

    private String getTimePart(CronEditorBean bean) {
        StringBuffer desc = new StringBuffer();
        if (!bean.isRange()) {
            desc.append(this.getRunOnce(bean));
        } else {
            desc.append(this.getRepeatInRange(bean));
        }
        return desc.toString();
    }

    private String getRunOnce(CronEditorBean bean) {
        StringBuffer desc = new StringBuffer();
        desc.append(this.i18n.getText("cron.editor.at"));
        desc.append(" ");
        desc.append(bean.getHoursRunOnce()).append(":").append(this.getPaddedMinutes(bean.getMinutes())).append(" ").append(bean.getHoursRunOnceMeridian());
        return desc.toString();
    }

    private String getRepeatInRange(CronEditorBean bean) {
        StringBuffer desc = new StringBuffer();
        String increment = bean.getIncrementInMinutes();
        if (!increment.equals("0")) {
            String key = MINUTE_INCREMENT_TO_MESG_KEY.get(increment);
            desc.append(this.i18n.getText(key));
        }
        if (!bean.is24HourRange()) {
            desc.append(" ");
            desc.append(this.i18n.getText("cron.editor.from"));
            desc.append(" ");
            desc.append(bean.getHoursFrom()).append(":00 ").append(bean.getHoursFromMeridian());
            desc.append(" ");
            desc.append(this.i18n.getText("cron.editor.to"));
            desc.append(" ");
            desc.append(bean.getHoursTo()).append(":00 ").append(bean.getHoursToMeridian());
        }
        return desc.toString();
    }

    private String getPaddedMinutes(String minutes) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumIntegerDigits(2);
        return format.format(Integer.parseInt(minutes));
    }

    static {
        HashMap<String, String> dayNumbers = new HashMap<String, String>();
        dayNumbers.put("1", "sunday");
        dayNumbers.put("2", "monday");
        dayNumbers.put("3", "tuesday");
        dayNumbers.put("4", "wednesday");
        dayNumbers.put("5", "thursday");
        dayNumbers.put("6", "friday");
        dayNumbers.put("7", "saturday");
        DAY_NUMBERS = Collections.unmodifiableMap(dayNumbers);
    }
}

