/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserNameComparator;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class UserPickerFilter
extends PagerFilter {
    private String nameFilter;
    private String emailFilter;
    private String group;
    private final Locale userLocale;

    public UserPickerFilter(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.nameFilter = FilterUtils.verifyString(nameFilter);
    }

    public String getEmailFilter() {
        return this.emailFilter;
    }

    public void setEmailFilter(String emailFilter) {
        this.emailFilter = FilterUtils.verifyString(emailFilter);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public List<User> getFilteredUsers() throws Exception {
        ArrayList<User> filteredUsers = new ArrayList<User>();
        Collection users = this.getUsersFilteredByGroup();
        for (User user : users) {
            if (this.nameFilter != null && this.emailFilter != null) {
                if (user.getEmailAddress() == null || user.getEmailAddress().toLowerCase().indexOf(this.emailFilter.toLowerCase()) < 0 || user.getDisplayName() == null || user.getDisplayName().toLowerCase().indexOf(this.nameFilter.toLowerCase()) < 0) continue;
                filteredUsers.add(user);
                continue;
            }
            if (this.emailFilter == null && this.nameFilter == null) {
                filteredUsers.add(user);
                continue;
            }
            if (this.emailFilter == null && this.nameFilter != null && user.getDisplayName() != null && user.getDisplayName().toLowerCase().indexOf(this.nameFilter.toLowerCase()) >= 0) {
                filteredUsers.add(user);
                continue;
            }
            if (this.nameFilter != null || this.emailFilter == null || user.getEmailAddress() == null || user.getEmailAddress().toLowerCase().indexOf(this.emailFilter.toLowerCase()) < 0) continue;
            filteredUsers.add(user);
        }
        Collections.sort(filteredUsers, new UserNameComparator(this.userLocale));
        return filteredUsers;
    }

    private Collection getUsersFilteredByGroup() {
        UserUtil userUtil = ComponentAccessor.getUserUtil();
        if (this.group != null) {
            return userUtil.getUsersInGroupNames(EasyList.build((Object)this.group));
        }
        return userUtil.getUsers();
    }
}

