/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.TimeTrackingGraphBean;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import java.util.Locale;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TimeTrackingGraphBeanFactoryImpl
implements TimeTrackingGraphBeanFactory {
    private final JiraDurationUtils utils;

    public TimeTrackingGraphBeanFactoryImpl(JiraDurationUtils utils) {
        this.utils = Assertions.notNull("utils", utils);
    }

    @Override
    public TimeTrackingGraphBean createBean(Issue issue, TimeTrackingGraphBeanFactory.Style style, I18nHelper helper) {
        Assertions.notNull("helper", helper);
        Assertions.notNull("issue", issue);
        Assertions.notNull("style", style);
        Long orig = issue.getOriginalEstimate();
        Long estimate = issue.getEstimate();
        Long spent = issue.getTimeSpent();
        return this.createBean(style, helper, orig, spent, estimate);
    }

    @Override
    public TimeTrackingGraphBean createBean(AggregateTimeTrackingBean aggregateBean, TimeTrackingGraphBeanFactory.Style style, I18nHelper helper) {
        Assertions.notNull("helper", helper);
        Assertions.notNull("aggregateBean", aggregateBean);
        Assertions.notNull("style", style);
        Long spent = aggregateBean.getTimeSpent();
        Long estimate = aggregateBean.getRemainingEstimate();
        Long orig = aggregateBean.getOriginalEstimate();
        return this.createBean(style, helper, orig, spent, estimate);
    }

    private TimeTrackingGraphBean createBean(TimeTrackingGraphBeanFactory.Style style, I18nHelper helper, Long originalEstimate, Long timeSpent, Long remainingEstimate) {
        TimeTrackingGraphBean.Parameters params = new TimeTrackingGraphBean.Parameters(helper);
        params.setOriginalEstimate(originalEstimate);
        params.setRemainingEstimate(remainingEstimate);
        params.setTimeSpent(timeSpent);
        Locale locale = helper.getLocale();
        params.setTimeSpentStr(style.getDuration(timeSpent, locale, this.utils));
        params.setOriginalEstimateStr(style.getDuration(originalEstimate, locale, this.utils));
        params.setRemainingEstimateStr(style.getDuration(remainingEstimate, locale, this.utils));
        params.setTimeSpentTooltip(style.getTooltip(timeSpent, locale, this.utils));
        params.setOriginalEstimateTooltip(style.getTooltip(originalEstimate, locale, this.utils));
        params.setRemainingEstimateTooltip(style.getTooltip(remainingEstimate, locale, this.utils));
        return new TimeTrackingGraphBean(params);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

