/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.core.util.DateUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class TaskDescriptorBean<V>
implements TaskDescriptor<V> {
    private final TaskDescriptor<V> taskDescriptor;
    private final I18nHelper i18nHelper;
    private final OutlookDateManager outlookDateManager;
    private Throwable exceptionCause;
    private final User currentUser;
    private final TaskProgressEvent lastProgressEvent;

    public TaskDescriptorBean(TaskDescriptor<V> taskDescriptor, I18nHelper i18nHelper, OutlookDateManager outlookDateManager, User currentUser) {
        Assertions.notNull("taskDescriptor", taskDescriptor);
        Assertions.notNull("i18nHelper", i18nHelper);
        Assertions.notNull("outlookDateManager", outlookDateManager);
        this.currentUser = currentUser;
        this.taskDescriptor = taskDescriptor;
        this.i18nHelper = i18nHelper;
        this.outlookDateManager = outlookDateManager;
        this.exceptionCause = null;
        TaskProgressIndicator taskProgressIndicator = taskDescriptor.getTaskProgressIndicator();
        this.lastProgressEvent = taskProgressIndicator == null ? null : taskProgressIndicator.getLastProgressEvent();
    }

    public TaskDescriptor getTaskDescriptor() {
        return this.taskDescriptor;
    }

    public String getFormattedElapsedRunTime() {
        long elaspedTime = this.taskDescriptor.getElapsedRunTime() / 1000L;
        ResourceBundle resourceBundle = this.i18nHelper.getDefaultResourceBundle();
        return DateUtils.getDurationPrettySecondsResolution((long)elaspedTime, (ResourceBundle)resourceBundle);
    }

    @Override
    public V getResult() throws ExecutionException, InterruptedException {
        return this.taskDescriptor.getResult();
    }

    @Override
    public boolean isStarted() {
        return this.taskDescriptor.isStarted();
    }

    @Override
    public boolean isFinished() {
        return this.taskDescriptor.isFinished();
    }

    @Override
    public Long getTaskId() {
        return this.taskDescriptor.getTaskId();
    }

    @Override
    public Date getStartedTimestamp() {
        return this.taskDescriptor.getStartedTimestamp();
    }

    public String getFormattedStartedTimestamp() {
        return this.getFormattedTimestamp(this.getStartedTimestamp());
    }

    @Override
    public Date getFinishedTimestamp() {
        return this.taskDescriptor.getFinishedTimestamp();
    }

    public String getFormattedFinishedTimestamp() {
        return this.getFormattedTimestamp(this.getFinishedTimestamp());
    }

    @Override
    public Date getSubmittedTimestamp() {
        return this.taskDescriptor.getSubmittedTimestamp();
    }

    public String getFormattedSubmittedTimestamp() {
        return this.getFormattedTimestamp(this.getSubmittedTimestamp());
    }

    @Override
    public long getElapsedRunTime() {
        return this.taskDescriptor.getElapsedRunTime();
    }

    @Override
    public User getUser() {
        return this.taskDescriptor.getUser();
    }

    @Override
    public String getDescription() {
        return this.taskDescriptor.getDescription();
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskDescriptor.getTaskContext();
    }

    @Override
    public TaskProgressIndicator getTaskProgressIndicator() {
        return null;
    }

    public String getFormattedProgress() {
        if (!this.taskDescriptor.isStarted()) {
            return this.i18nHelper.getText("common.tasks.info.starting", this.getFormattedSubmittedTimestamp());
        }
        if (this.taskDescriptor.isFinished()) {
            if (this.exceptionCause != null) {
                return this.i18nHelper.getText("common.tasks.info.completed.with.error", this.getFormattedElapsedRunTime());
            }
            return this.i18nHelper.getText("common.tasks.info.completed", this.getFormattedElapsedRunTime());
        }
        if (this.lastProgressEvent != null && this.lastProgressEvent.getTaskProgress() >= 0L) {
            return this.i18nHelper.getText("common.tasks.info.progressing", String.valueOf(this.getProgressNumber()), this.getFormattedElapsedRunTime());
        }
        return this.i18nHelper.getText("common.tasks.info.progress.unknown", this.getFormattedElapsedRunTime());
    }

    public long getProgressNumber() {
        if (this.taskDescriptor.isFinished() || this.taskDescriptor.getTaskProgressIndicator() == null) {
            return 100L;
        }
        if (this.lastProgressEvent == null) {
            return 0L;
        }
        return Math.max(Math.min(100L, this.lastProgressEvent.getTaskProgress()), 0L);
    }

    public long getInverseProgressNumber() {
        return 100L - this.getProgressNumber();
    }

    public void setExceptionCause(Throwable cause) {
        this.exceptionCause = cause;
    }

    public Throwable getExceptionCause() {
        return this.exceptionCause;
    }

    public String getFormattedExceptionCause() {
        if (this.exceptionCause != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.exceptionCause.printStackTrace(printWriter);
            printWriter.close();
            return stringWriter.toString();
        }
        return null;
    }

    public boolean isUserWhoStartedTask() {
        return this.currentUser == null && this.taskDescriptor.getUser() == null || this.currentUser != null && this.currentUser.equals(this.taskDescriptor.getUser());
    }

    @Override
    public String getProgressURL() {
        String progressURL = this.taskDescriptor.getProgressURL();
        HttpServletRequest servletRequest = ActionContext.getRequest();
        if (servletRequest != null) {
            progressURL = servletRequest.getContextPath() + progressURL;
        }
        return progressURL;
    }

    public String getUserURL() {
        if (this.getUser() != null) {
            String usrURL = "/secure/admin/user/ViewUser.jspa?name=" + this.getUser().getName();
            HttpServletRequest servletRequest = ActionContext.getRequest();
            if (servletRequest != null && servletRequest.getContextPath() != null) {
                usrURL = servletRequest.getContextPath() + usrURL;
            }
            return usrURL;
        }
        return "";
    }

    public TaskProgressEvent getLastProgressEvent() {
        return this.lastProgressEvent;
    }

    private String getFormattedTimestamp(Date timestamp) {
        if (timestamp != null) {
            OutlookDate date = this.outlookDateManager.getOutlookDate(this.i18nHelper.getLocale());
            return date.format(timestamp);
        }
        return "";
    }
}

