/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Map;

public class ShareTypeRendererBean {
    private final JiraAuthenticationContext authenticationContext;
    private final ShareTypeRenderer renderer;
    private final ShareType.Name shareTypeName;
    private final ShareTypeRenderer.RenderMode renderMode;
    private final SharedEntity.TypeDescriptor typeDescriptor;

    public ShareTypeRendererBean(ShareType shareType, JiraAuthenticationContext authenticationContext, ShareTypeRenderer.RenderMode renderMode, SharedEntity.TypeDescriptor typeDescriptor) {
        Assertions.notNull("shareType", shareType);
        Assertions.notNull("authenticationContext", authenticationContext);
        Assertions.notNull("renderMode", renderMode);
        Assertions.notNull("typeDescriptor", typeDescriptor);
        this.typeDescriptor = typeDescriptor;
        this.authenticationContext = authenticationContext;
        this.renderMode = renderMode;
        this.shareTypeName = shareType.getType();
        this.renderer = shareType.getRenderer();
    }

    public String getShareType() {
        return this.shareTypeName.get();
    }

    public String getShareTypeEditor() {
        return this.renderer.getShareTypeEditor(this.authenticationContext);
    }

    public String getShareTypeSelector() {
        return this.renderer.getShareTypeEditor(this.authenticationContext);
    }

    public boolean isAddButtonNeeded() {
        return this.renderer.isAddButtonNeeded(this.authenticationContext);
    }

    public String getShareTypeLabel() {
        return this.renderer.getShareTypeLabel(this.authenticationContext);
    }

    public Map getTranslatedTemplates() {
        return this.renderer.getTranslatedTemplates(this.authenticationContext, this.typeDescriptor, this.renderMode);
    }
}

