/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.BeanComparatorIgnoreCase;
import com.atlassian.jira.issue.comparator.KeyComparator;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.BulkTransitionIssueOperation;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.security.IssueSecurityHelper;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.web.action.issue.bulkedit.WorkflowTransitionKey;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBeanImpl;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.mail.MailFactory;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.MultiMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkEditBeanImpl
implements BulkEditBean {
    private int currentStep = 1;
    private final Set<Integer> availablePreviousSteps = new HashSet<Integer>();
    private Map<String, BulkEditAction> actions;
    private GenericValue project;
    private Set<Long> projectIds;
    private Set<GenericValue> projects;
    private Set<String> issueTypeIds;
    private String operationName;
    private List<Issue> issuesFromSearchRequest;
    private List<Issue> selectedIssues;
    private List<Issue> subTaskOfSelectedIssues;
    private List<Long> selectedIssueIds;
    private List<Issue> selectedIssuesIncSubTasks;
    private BulkEditBean subTaskBulkEditBean;
    private Collection<?> issuesInUse;
    private final Map<String, Object> fieldValues = new HashMap<String, Object>();
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private Map<String, String> statusMapHolder = new HashMap<String, String>();
    private Map<String, Map<Long, Long>> fieldSubstitutionMap = new LinkedHashMap<String, Map<Long, Long>>();
    private Map<String, ?> params;
    private Set<FieldLayout> fieldLayouts;
    private Set<String> invalidSubTaskTypes;
    private Map<String, Set<String>> invalidSubTaskStatusesByType;
    private Collection<String> subTaskStatusHolder;
    private Set<Status> invalidStatuses;
    private Set<Issue> invalidIssues;
    private Set<?> removedFields;
    private FieldLayout targetFieldLayout;
    private Map<Issue, Issue> targetIssueObjects;
    private JiraWorkflow targetWorkflow;
    private Collection<?> moveFieldLayoutItems;
    private int subTaskCount = -1;
    private int invalidSubTaskCount = -1;
    private Set<String> retainValues;
    private Map<?, ?> messagedFieldLayoutItems;
    private boolean sendBulkNotification = false;
    private MultiMap workflowTransitionMap;
    private WorkflowTransitionKey selectedWFTransitionKey;
    private FieldScreenRenderer fieldScreenRenderer;
    private MultiBulkMoveBean relatedMultiBulkMoveBean;
    private BulkEditBean parentBulkEditBean;
    private final IssueManager issueManager;
    private int maxIssues = -1;

    public BulkEditBeanImpl(IssueManager issueManager) {
        this.issueManager = issueManager;
    }

    @Override
    public BulkEditBean getParentBulkEditBean() {
        return this.parentBulkEditBean;
    }

    @Override
    public void initSelectedIssues(Collection<Issue> selectedIssues) {
        this.selectedIssues = null;
        this.setSelectedIssueIds(selectedIssues);
    }

    @Override
    public void addIssues(Collection<Issue> issues) {
        this.selectedIssues = null;
        this.addIssueIds(issues);
        this.resetMoveData();
    }

    @Override
    public List<Issue> getSelectedIssues() {
        if (this.selectedIssues == null) {
            this.initSelectedIssues();
        }
        return this.selectedIssues;
    }

    @Override
    public List<Issue> getSelectedIssuesIncludingSubTasks() {
        if (this.selectedIssuesIncSubTasks == null) {
            this.initSelectedIssuesIncSubTasks();
        }
        return this.selectedIssuesIncSubTasks;
    }

    @Override
    public boolean isChecked(Issue issue) {
        return this.getSelectedIssues().contains(issue);
    }

    @Override
    public boolean isMultipleProjects() {
        return this.getProjectIds().size() > 1;
    }

    @Override
    public boolean isMutipleIssueTypes() {
        return this.getIssueTypes().size() > 1;
    }

    @Override
    public GenericValue getProject() {
        if (this.project == null && !this.getProjectIds().isEmpty()) {
            this.project = this.getProject(this.getProjectIds().iterator().next());
        }
        return this.project;
    }

    @Override
    public GenericValue getIssueType() {
        if (!this.getIssueTypes().isEmpty()) {
            return ComponentAccessor.getConstantsManager().getIssueType(this.getIssueTypes().iterator().next());
        }
        return null;
    }

    @Override
    public Collection<FieldLayout> getFieldLayouts() {
        if (this.fieldLayouts == null) {
            this.fieldLayouts = new HashSet<FieldLayout>();
            FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
            for (Issue issue : this.getSelectedIssues()) {
                this.fieldLayouts.add(fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()));
            }
        }
        return this.fieldLayouts;
    }

    @Override
    public String getKey() {
        StringBuffer key = new StringBuffer();
        for (Long projectId : this.getProjectIds()) {
            key.append(projectId);
        }
        key.append("_");
        for (IssueType issueType : this.getIssueTypeObjects()) {
            key.append(issueType.getId());
        }
        key.append("_");
        if (this.isSubTaskOnly()) {
            key.append(this.getTargetPid()).append("_");
        }
        return key.toString();
    }

    @Override
    public Collection<Long> getProjectIds() {
        if (this.projectIds == null) {
            this.initIssueProperties();
        }
        return this.projectIds;
    }

    @Override
    public Collection<GenericValue> getProjects() {
        if (this.project == null) {
            this.initIssueProperties();
        }
        return this.projects;
    }

    @Override
    public Collection<String> getIssueTypes() {
        if (this.issueTypeIds == null) {
            this.initIssueProperties();
        }
        return this.issueTypeIds;
    }

    @Override
    public Collection<IssueType> getIssueTypeObjects() {
        return Transformed.collection(this.getIssueTypes(), new com.atlassian.jira.util.Function<String, IssueType>(){

            @Override
            public IssueType get(String input) {
                return ManagerFactory.getConstantsManager().getIssueTypeObject(input);
            }
        });
    }

    private void initIssueProperties() {
        this.projectIds = new HashSet<Long>();
        this.projects = new HashSet<GenericValue>();
        this.issueTypeIds = new HashSet<String>();
        for (Issue issue : this.getSelectedIssues()) {
            GenericValue project = issue.getProject();
            this.projects.add(project);
            this.projectIds.add(project.getLong("id"));
            this.issueTypeIds.add(issue.getIssueTypeObject().getId());
        }
    }

    private void initInvalidStatuses() throws WorkflowException {
        this.invalidStatuses = Sets.newHashSet();
        this.invalidIssues = new HashSet<Issue>();
        JiraWorkflow workflow = this.getWorkflowManager().getWorkflow(this.getTargetPid(), this.getTargetIssueTypeId());
        List<Status> validStatuses = workflow.getLinkedStatusObjects();
        for (Issue issue : this.getSelectedIssues()) {
            Status status = issue.getStatusObject();
            if (status == null) {
                this.invalidIssues.add(issue);
            }
            if (validStatuses.contains(status)) continue;
            this.invalidStatuses.add(status);
        }
    }

    @Override
    public String getCheckboxName(Issue issue) {
        return "bulkedit_" + issue.getId();
    }

    @Override
    public CustomField getCustomField(String customFieldKey) throws GenericEntityException {
        return ManagerFactory.getCustomFieldManager().getCustomFieldObject(customFieldKey);
    }

    @Override
    public String getCustomFieldView(CustomField customField) throws FieldValidationException {
        Object value = this.getFieldValues().get(customField);
        FieldLayoutItem layoutItem = null;
        if (!this.getFieldLayouts().isEmpty()) {
            layoutItem = this.getFieldLayouts().iterator().next().getFieldLayoutItem(customField);
        }
        return customField.getCustomFieldType().getDescriptor().getViewHtml(customField, value, null, layoutItem);
    }

    private void refresh() {
        this.selectedIssueIds = null;
        this.selectedIssues = null;
        this.projectIds = null;
        this.project = null;
    }

    @Override
    public void setParams(Map<String, ?> params) {
        this.params = params;
        this.refresh();
    }

    @Override
    public Map<String, ?> getParams() {
        return this.params;
    }

    @Override
    public void setIssuesInUse(Collection<?> issuesInUse) {
        this.issuesInUse = issuesInUse;
        this.project = null;
        this.projectIds = null;
        this.issueTypeIds = null;
    }

    @Override
    public void addAvailablePreviousStep(int stepId) {
        this.availablePreviousSteps.add(new Integer(stepId));
    }

    @Override
    public void clearAvailablePreviousSteps() {
        this.availablePreviousSteps.clear();
    }

    @Override
    public boolean isAvailablePreviousStep(int stepId) {
        return this.availablePreviousSteps.contains(new Integer(stepId));
    }

    @Deprecated
    private static MutableIssue getIssueObject(GenericValue genericValue) {
        return IssueImpl.getIssueObject(genericValue);
    }

    @Override
    public boolean isHasMailServer() {
        try {
            if (MailFactory.getServerManager().getDefaultSMTPMailServer() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Collection<?> getMoveFieldLayoutItems() {
        return this.moveFieldLayoutItems;
    }

    @Override
    public void setMoveFieldLayoutItems(Collection<?> moveFieldLayoutItems) {
        this.moveFieldLayoutItems = moveFieldLayoutItems;
    }

    @Override
    public Long getTargetPid() {
        return (Long)this.getFieldValuesHolder().get("project");
    }

    @Override
    public void setTargetProject(GenericValue project) {
        if (project != null) {
            this.getFieldValuesHolder().put("project", project.getLong("id"));
        } else {
            this.getFieldValuesHolder().put("project", null);
        }
    }

    @Override
    public Project getTargetProject() {
        return ComponentAccessor.getProjectManager().getProjectObj(this.getTargetPid());
    }

    @Override
    public GenericValue getTargetProjectGV() {
        return ComponentAccessor.getProjectManager().getProject(this.getTargetPid());
    }

    @Override
    public void setTargetIssueTypeId(String id) {
        this.getFieldValuesHolder().put("issuetype", id);
    }

    @Override
    public String getTargetIssueTypeId() {
        return (String)this.getFieldValuesHolder().get("issuetype");
    }

    @Override
    public GenericValue getTargetIssueTypeGV() {
        return ComponentAccessor.getConstantsManager().getIssueType(this.getTargetIssueTypeId());
    }

    @Override
    public IssueType getTargetIssueTypeObject() {
        return ComponentAccessor.getConstantsManager().getIssueTypeObject(this.getTargetIssueTypeId());
    }

    @Override
    public void populateStatusHolder() throws WorkflowException {
        Map actionParameters = ActionContext.getParameters();
        for (GenericValue status : this.getInvalidStatuses()) {
            String statusKey = status.getString("id");
            this.statusMapHolder.put(statusKey, ParameterUtils.getStringParam(actionParameters, statusKey));
        }
    }

    @Override
    public Collection<GenericValue> getInvalidStatuses() throws WorkflowException {
        if (this.invalidStatuses == null) {
            this.initInvalidStatuses();
        }
        return Collections2.transform(this.invalidStatuses, (Function)new StatusToStatusGV());
    }

    @Override
    public Set<Issue> getInvalidIssues() throws WorkflowException {
        if (this.invalidIssues == null) {
            this.initInvalidStatuses();
        }
        return this.invalidIssues;
    }

    @Override
    public Set<String> getInvalidSubTaskTypes() throws WorkflowException {
        if (this.invalidSubTaskTypes == null) {
            this.invalidSubTaskTypes = new HashSet<String>();
            this.invalidSubTaskCount = 0;
            List<Issue> selectedIssues = this.getSelectedIssues();
            ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
            for (Issue issue : selectedIssues) {
                Collection<GenericValue> subTasks = issue.getSubTasks();
                for (GenericValue subTask : subTasks) {
                    HashSet<String> invalidStatuses;
                    String subTaskTypeId = subTask.getString("type");
                    String subTaskStatusId = subTask.getString("status");
                    GenericValue subTaskStatusGV = constantsManager.getStatus(subTaskStatusId);
                    JiraWorkflow targetSubTaskWorkflow = this.getWorkflowForType(this.getTargetPid(), subTaskTypeId);
                    if (targetSubTaskWorkflow.getLinkedStatuses().contains(subTaskStatusGV)) continue;
                    this.invalidSubTaskTypes.add(subTaskTypeId);
                    ++this.invalidSubTaskCount;
                    if (this.invalidSubTaskStatusesByType != null && !this.invalidSubTaskStatusesByType.isEmpty()) {
                        if (this.invalidSubTaskStatusesByType.containsKey(subTaskTypeId)) {
                            invalidStatuses = new HashSet(this.invalidSubTaskStatusesByType.get(subTaskTypeId));
                            invalidStatuses.add(subTaskStatusId);
                            this.invalidSubTaskStatusesByType.put(subTaskTypeId, invalidStatuses);
                            continue;
                        }
                        invalidStatuses = new HashSet();
                        invalidStatuses.add(subTaskStatusGV.getString("id"));
                        this.invalidSubTaskStatusesByType.put(subTaskTypeId, invalidStatuses);
                        continue;
                    }
                    this.invalidSubTaskStatusesByType = new HashMap<String, Set<String>>();
                    invalidStatuses = new HashSet<String>();
                    invalidStatuses.add(subTaskStatusGV.getString("id"));
                    this.invalidSubTaskStatusesByType.put(subTaskTypeId, invalidStatuses);
                }
            }
        }
        return this.invalidSubTaskTypes;
    }

    @Override
    public Set<String> getInvalidSubTaskStatusesByType(String subTaskTypeId) throws WorkflowException {
        if (this.invalidSubTaskStatusesByType == null) {
            this.getInvalidSubTaskTypes();
        }
        return this.invalidSubTaskStatusesByType.get(subTaskTypeId);
    }

    @Override
    public void setTargetFieldLayout() {
        FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        this.targetFieldLayout = fieldLayoutManager.getFieldLayout(this.getTargetProjectGV(), this.getTargetIssueTypeId());
    }

    @Override
    public FieldLayout getTargetFieldLayout() {
        return this.targetFieldLayout;
    }

    @Override
    public FieldLayout getTargetFieldLayoutForType(String targetTypeId) {
        FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        return fieldLayoutManager.getFieldLayout(this.getTargetProjectGV(), targetTypeId);
    }

    @Override
    public JiraWorkflow getTargetWorkflow() throws WorkflowException {
        if (this.targetWorkflow == null) {
            this.targetWorkflow = this.getWorkflowForType(this.getTargetPid(), this.getTargetIssueTypeId());
        }
        return this.targetWorkflow;
    }

    @Override
    public Issue getFirstTargetIssueObject() {
        if (this.getTargetIssueObjects().isEmpty()) {
            return null;
        }
        return this.getTargetIssueObjects().values().iterator().next();
    }

    @Override
    public Map<Issue, Issue> getTargetIssueObjects() {
        if (this.targetIssueObjects == null) {
            this.targetIssueObjects = new HashMap<Issue, Issue>();
            for (Issue selectedIssue : this.getSelectedIssues()) {
                IssueSecurityHelper issueSecurityHelper;
                MutableIssue cloneIssue = this.issueManager.getIssueObject(selectedIssue.getGenericValue().getLong("id"));
                if (this.getTargetPid() != null) {
                    cloneIssue.setProjectId(this.getTargetPid());
                }
                cloneIssue.setIssueTypeId(this.getTargetIssueTypeId());
                if (this.parentBulkEditBean != null && cloneIssue.isSubTask()) {
                    Issue parent = this.getParentTargetIssue(cloneIssue.getParentId());
                    if (parent == null) {
                        throw new IllegalStateException("Could not find parent [" + cloneIssue.getParentId() + "] for subtask [" + cloneIssue.getId() + "] in the parent BulkEditBean.");
                    }
                    cloneIssue.setParentObject(parent);
                }
                if ((issueSecurityHelper = this.getIssueSecurityHelper()).securityLevelNeedsMove(selectedIssue, cloneIssue)) {
                    cloneIssue.setSecurityLevel(null);
                }
                this.targetIssueObjects.put(selectedIssue, cloneIssue);
            }
        }
        return this.targetIssueObjects;
    }

    private Issue getParentTargetIssue(Long issueId) {
        if (issueId == null) {
            return null;
        }
        for (Issue issue : this.parentBulkEditBean.getTargetIssueObjects().values()) {
            if (!issueId.equals(issue.getId())) continue;
            return issue;
        }
        return null;
    }

    @Override
    public void setTargetIssueObjects(Map<Issue, Issue> targetIssueObjects) {
        this.targetIssueObjects = targetIssueObjects;
    }

    @Override
    public List<GenericValue> getTargetIssueGVs() {
        ArrayList<GenericValue> gvs = new ArrayList<GenericValue>();
        for (Issue issue : this.getTargetIssueObjects().values()) {
            gvs.add(issue.getGenericValue());
        }
        return gvs;
    }

    @Override
    public Status getTargetStatusObject(Issue issue) {
        GenericValue targetStatusGV = this.getTargetStatus(issue);
        return ComponentAccessor.getConstantsManager().getStatusObject(targetStatusGV != null ? targetStatusGV.getString("id") : null);
    }

    @Override
    public GenericValue getTargetStatus(Issue issue) {
        String statusId = this.statusMapHolder.get(issue.getStatusObject().getId());
        if (statusId != null) {
            return ComponentAccessor.getConstantsManager().getStatus(statusId);
        }
        return null;
    }

    private JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.getWorkflowManager().getWorkflow(projectId, issueTypeId);
    }

    @Override
    public Map<String, String> getStatusMapHolder() {
        return this.statusMapHolder;
    }

    @Override
    public Collection<?> getRemovedFields() {
        return this.removedFields;
    }

    @Override
    public void setRemovedFields(Set<?> removedFields) {
        this.removedFields = removedFields;
    }

    @Override
    public void resetMoveData() {
        if (this.getMoveFieldLayoutItems() != null && !this.getMoveFieldLayoutItems().isEmpty()) {
            this.setSelectedIssueIds(this.getSelectedIssues());
            this.selectedIssues = null;
        }
        this.setRemovedFields(null);
        this.setMoveFieldLayoutItems(null);
        this.setInvalidSubTaskTypes(null);
        this.setInvalidSubTaskStatusesByType(null);
        this.setRetainValues(null);
        this.setTargetIssueObjects(null);
        this.setInvalidStatuses(null);
        this.invalidIssues = null;
        this.setSubTaskBulkEditBean(null);
        this.setRelatedMultiBulkMoveBean(null);
        this.statusMapHolder = new HashMap<String, String>();
        this.projectIds = null;
        this.projects = null;
        this.issueTypeIds = null;
    }

    @Override
    public void populateSubTaskStatusHolder() throws WorkflowException {
        Map actionParameters = ActionContext.getParameters();
        this.subTaskStatusHolder = new ArrayList<String>();
        for (String actionKey : actionParameters.keySet()) {
            String[] value;
            if (actionKey.indexOf("subtaskstatusinfo_") == -1 || (value = (String[])actionParameters.get(actionKey)) == null || value.length == 0) continue;
            this.subTaskStatusHolder.add(actionKey + "_" + value[0]);
        }
    }

    @Override
    public JiraWorkflow getTargetWorkflowByType(String issueTypeId) throws WorkflowException {
        return this.getWorkflowForType(this.getTargetPid(), issueTypeId);
    }

    private WorkflowManager getWorkflowManager() {
        return ComponentAccessor.getWorkflowManager();
    }

    private void initSelectedIssuesIncSubTasks() {
        HashSet<Issue> issueSet = new HashSet<Issue>();
        issueSet.addAll(this.getSelectedIssues());
        issueSet.addAll(this.getSubTaskOfSelectedIssues());
        this.selectedIssuesIncSubTasks = new ArrayList<Issue>(issueSet);
        Collections.sort(this.selectedIssuesIncSubTasks, new BeanComparatorIgnoreCase("key"));
    }

    private void initSelectedIssues() {
        this.subTaskCount = 0;
        this.selectedIssues = new ArrayList<Issue>();
        this.subTaskOfSelectedIssues = new ArrayList<Issue>();
        for (Long issueId : this.getSelectedIds()) {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            if (issue == null) continue;
            if (issue.isSubTask()) {
                ++this.subTaskCount;
            }
            this.selectedIssues.add(issue);
            this.subTaskOfSelectedIssues.addAll(issue.getSubTaskObjects());
        }
    }

    private GenericValue getProject(Long projectId) {
        return ManagerFactory.getProjectManager().getProject(projectId);
    }

    private List<Long> getSelectedIds() {
        if (this.selectedIssueIds == null) {
            this.selectedIssueIds = new ArrayList<Long>();
            if (this.getParams() == null) {
                return this.selectedIssueIds;
            }
            for (String issueKey : this.getParams().keySet()) {
                if (!issueKey.startsWith("bulkedit_")) continue;
                this.selectedIssueIds.add(new Long(issueKey.substring("bulkedit_".length())));
            }
        }
        return this.selectedIssueIds;
    }

    private void setSelectedIssueIds(Collection<Issue> issues) {
        if (this.selectedIssueIds == null) {
            this.selectedIssueIds = new ArrayList<Long>();
        } else {
            this.selectedIssueIds.clear();
        }
        this.addIssueIds(issues);
    }

    private void addIssueIds(Collection<Issue> issues) {
        for (Issue issue : issues) {
            this.selectedIssueIds.add(issue.getId());
        }
    }

    @Override
    public Collection<String> getSubTaskStatusHolder() {
        return this.subTaskStatusHolder;
    }

    @Override
    public boolean isRetainChecked(String fieldId) {
        return this.retainValues == null ? false : this.retainValues.contains(fieldId);
    }

    @Override
    public boolean isSubTaskCollection() {
        return this.getSubTaskCount() > 0;
    }

    @Override
    public boolean isSubTaskOnly() {
        return this.getSubTaskCount() == this.getSelectedIds().size();
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    @Override
    public void setInvalidSubTaskStatusesByType(Map<String, Set<String>> invalidSubTaskStatusesByType) {
        this.invalidSubTaskStatusesByType = invalidSubTaskStatusesByType;
    }

    @Override
    public void setInvalidSubTaskTypes(Set<String> invalidSubTaskTypes) {
        this.invalidSubTaskTypes = invalidSubTaskTypes;
    }

    private int getSubTaskCount() {
        if (this.selectedIssues == null) {
            this.initSelectedIssues();
        }
        return this.subTaskCount;
    }

    @Override
    public int getInvalidSubTaskCount() {
        return this.invalidSubTaskCount;
    }

    @Override
    public Set<String> getRetainValues() {
        return this.retainValues;
    }

    @Override
    public void setRetainValues(Set<String> retainValues) {
        this.retainValues = retainValues;
    }

    @Override
    public void addRetainValue(String fieldId) {
        if (this.retainValues == null) {
            this.retainValues = new HashSet<String>();
        }
        this.retainValues.add(fieldId);
    }

    private void setInvalidStatuses(Set<Status> invalidStatuses) {
        this.invalidStatuses = invalidStatuses;
    }

    @Override
    public List<Issue> getSubTaskOfSelectedIssues() {
        return this.subTaskOfSelectedIssues;
    }

    @Override
    public void setSubTaskOfSelectedIssues(List<Issue> subTaskOfSelectedIssues) {
        this.subTaskOfSelectedIssues = subTaskOfSelectedIssues;
    }

    @Override
    public List<Issue> getIssuesFromSearchRequest() {
        return this.issuesFromSearchRequest;
    }

    @Override
    public void setIssuesFromSearchRequest(List<Issue> issuesFromSearchRequest) {
        this.issuesFromSearchRequest = issuesFromSearchRequest;
    }

    @Override
    public int getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    @Override
    public Map<String, BulkEditAction> getActions() {
        return this.actions;
    }

    @Override
    public void setActions(Map<String, BulkEditAction> actions) {
        this.actions = actions;
    }

    @Override
    public Map<String, Object> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public Map<String, Object> getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    @Override
    public IssueOperation getIssueOperation() {
        BulkOperationManager bulkOperationManager = ComponentAccessor.getBulkOperationManager();
        if ("BulkWorkflowTransition".equals(this.getOperationName())) {
            JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(this.getSelectedWFTransitionKey().getWorkflowName());
            ActionDescriptor action = workflow.getDescriptor().getAction(Integer.parseInt(this.getSelectedWFTransitionKey().getActionDescriptorId()));
            return new BulkTransitionIssueOperation(bulkOperationManager.getOperation(this.getOperationName()), action);
        }
        return bulkOperationManager.getOperation(this.getOperationName());
    }

    @Override
    public Collection<?> getIssuesInUse() {
        return this.issuesInUse;
    }

    @Override
    public BulkEditBean getSubTaskBulkEditBean() {
        return this.subTaskBulkEditBean;
    }

    @Override
    public void setSubTaskBulkEditBean(BulkEditBean subTaskBulkEditBean) {
        this.subTaskBulkEditBean = subTaskBulkEditBean;
    }

    @Override
    public MultiBulkMoveBean getRelatedMultiBulkMoveBean() {
        return this.relatedMultiBulkMoveBean;
    }

    @Override
    public void setRelatedMultiBulkMoveBean(MultiBulkMoveBean relatedMultiBulkMoveBean) {
        this.relatedMultiBulkMoveBean = relatedMultiBulkMoveBean;
    }

    @Override
    public boolean isSendBulkNotification() {
        return this.sendBulkNotification;
    }

    @Override
    public void setSendBulkNotification(boolean sendBulkNotification) {
        this.sendBulkNotification = sendBulkNotification;
    }

    @Override
    public MultiMap getWorkflowTransitionMap() {
        return this.workflowTransitionMap;
    }

    @Override
    public void setWorkflowTransitionMap(MultiMap workflowTransitionMap) {
        this.workflowTransitionMap = workflowTransitionMap;
    }

    @Override
    public Set<String> getWorkflowsInUse() {
        Set workflowTransitionMapKeys = this.workflowTransitionMap.keySet();
        return CollectionUtil.transformSet(workflowTransitionMapKeys, new com.atlassian.jira.util.Function<WorkflowTransitionKey, String>(){

            @Override
            public String get(WorkflowTransitionKey input) {
                return input.getWorkflowName();
            }
        });
    }

    @Override
    public List<WorkflowTransitionKey> getTransitionIdsForWorkflow(String workflowName) {
        Set workflowTransitionMaps = this.workflowTransitionMap.keySet();
        ArrayList<WorkflowTransitionKey> transitionIdsForWorkflow = new ArrayList<WorkflowTransitionKey>();
        for (WorkflowTransitionKey wfTransitionKey : workflowTransitionMaps) {
            if (!wfTransitionKey.getWorkflowName().equals(workflowName)) continue;
            transitionIdsForWorkflow.add(wfTransitionKey);
        }
        Collections.sort(transitionIdsForWorkflow, new Comparator<WorkflowTransitionKey>(){

            @Override
            public int compare(WorkflowTransitionKey o1, WorkflowTransitionKey o2) {
                return o1.getActionDescriptorId().compareTo(o2.getActionDescriptorId());
            }
        });
        return transitionIdsForWorkflow;
    }

    @Override
    public String getTransitionName(String workflowName, String actionDescriptorId) {
        String key;
        I18nBean i18nBean;
        String value;
        JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(workflowName);
        ActionDescriptor descriptor = workflow.getDescriptor().getAction(Integer.parseInt(actionDescriptorId));
        Map metadata = descriptor.getMetaAttributes();
        if (metadata.containsKey("jira.issue.editable") && (value = (i18nBean = new I18nBean()).getText(key = (String)metadata.get("jira.issue.editable"))) != null && !"".equals(value.trim()) && !value.trim().equals(key.trim())) {
            return value;
        }
        return descriptor.getName();
    }

    @Override
    public List<String> getTransitionIssueKeys(WorkflowTransitionKey workflowTransitionKey) {
        ArrayList<String> workflowIssues = new ArrayList<String>((List)this.workflowTransitionMap.get((Object)workflowTransitionKey));
        Collections.sort(workflowIssues, KeyComparator.COMPARATOR);
        return workflowIssues;
    }

    @Override
    public void setSelectedWFTransitionKey(WorkflowTransitionKey workflowTransitionKey) {
        this.selectedWFTransitionKey = workflowTransitionKey;
    }

    @Override
    public WorkflowTransitionKey getSelectedWFTransitionKey() {
        return this.selectedWFTransitionKey;
    }

    @Override
    public void resetWorkflowTransitionSelection() {
        this.selectedWFTransitionKey = null;
    }

    @Override
    public boolean isTransitionChecked(WorkflowTransitionKey workflowTransitionKey) {
        return this.selectedWFTransitionKey != null && this.selectedWFTransitionKey.equals(workflowTransitionKey);
    }

    @Override
    public String getSelectedTransitionName() {
        return this.getTransitionName(this.selectedWFTransitionKey.getWorkflowName(), this.selectedWFTransitionKey.getActionDescriptorId());
    }

    @Override
    public void setFieldScreenRenderer(FieldScreenRenderer fieldScreenRenderer) {
        this.fieldScreenRenderer = fieldScreenRenderer;
    }

    @Override
    public FieldScreenRenderer getFieldScreenRenderer() {
        return this.fieldScreenRenderer;
    }

    @Deprecated
    public void _setSelectedIssueGVsForTesting(List<GenericValue> issues) {
        if (issues != null) {
            this.selectedIssues = new ArrayList<Issue>(issues.size());
            for (GenericValue issueGV : issues) {
                this.selectedIssues.add(BulkEditBeanImpl.getIssueObject(issueGV));
            }
        } else {
            this.selectedIssues = null;
        }
    }

    @Override
    public Map<?, ?> getMessagedFieldLayoutItems() {
        return this.messagedFieldLayoutItems;
    }

    @Override
    public void setMessagedFieldLayoutItems(Map<?, ?> messagedFieldLayoutItems) {
        this.messagedFieldLayoutItems = messagedFieldLayoutItems;
    }

    @Override
    public void initMultiBulkBean() {
        MultiBulkMoveBeanImpl multiBulkMoveBean = new MultiBulkMoveBeanImpl(this.getOperationName(), this.issueManager);
        multiBulkMoveBean.initFromIssues(this.getSelectedIssues(), null);
        this.setRelatedMultiBulkMoveBean(multiBulkMoveBean);
    }

    @Override
    public void initMultiBulkBeanWithSubTasks() {
        List<Issue> selectedIssues = this.getSubTaskBulkEditBean().getSelectedIssues();
        MultiBulkMoveBeanImpl multiBulkMoveBean = new MultiBulkMoveBeanImpl(this.getOperationName(), this.issueManager);
        multiBulkMoveBean.initFromIssues(selectedIssues, this);
        multiBulkMoveBean.setTargetProject(this.getTargetProjectGV());
        this.setRelatedMultiBulkMoveBean(multiBulkMoveBean);
    }

    @Override
    public boolean isOnlyContainsSubTasks() {
        return this.getSubTaskCount() == this.getSelectedIssues().size();
    }

    @Override
    public void setParentBulkEditBean(BulkEditBean parentBulkEditBean) {
        this.parentBulkEditBean = parentBulkEditBean;
    }

    IssueSecurityHelper getIssueSecurityHelper() {
        return ComponentManager.getComponent(IssueSecurityHelper.class);
    }

    @Override
    public int getMaxIssues() {
        return this.maxIssues;
    }

    @Override
    public void setMaxIssues(int maxIssues) {
        if (maxIssues < -1) {
            throw new IllegalArgumentException("max issues for bulk edit cannot be " + maxIssues);
        }
        this.maxIssues = maxIssues;
    }

    @Override
    public Map<String, Map<Long, Long>> getFieldSubstitutionMap() {
        return this.fieldSubstitutionMap;
    }

    private static class StatusToStatusGV
    implements Function<Status, GenericValue> {
        private StatusToStatusGV() {
        }

        public GenericValue apply(@Nullable Status status) {
            return status != null ? status.getGenericValue() : null;
        }
    }
}

