/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.plugin.util.InvolvedPluginsTracker;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.i18n.I18nTranslationMode;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;

@Immutable
@Internal
@VisibleForTesting
public class BackingI18n
implements I18nHelper {
    private static final Logger log = Logger.getLogger(I18nHelper.class);
    private static final char START_HIGHLIGHT_CHAR = '\ufeff';
    private static final char MIDDLE_HIGHLIGHT_CHAR = '\u26a1';
    private static final char END_HIGHLIGHT_CHAR = '\u2060';
    private static final String PLUGIN_RESOURCE_TYPE_I18N = "i18n";
    private static final ResourceNotFound NOT_FOUND = new ResourceNotFound();
    private final Locale locale;
    private final Map<String, Set<String>> prefixKeysCache = new MapMaker().makeComputingMap((Function)new PrefixFunction());
    private final Iterable<ResourceBundle> resourceBundlesInEffect;
    private final I18nTranslationMode i18nTranslationMode;
    private final InvolvedPluginsTracker involvedPluginsTracker;

    public BackingI18n(Locale locale, I18nTranslationMode i18nTranslationMode, InvolvedPluginsTracker involvedPluginsTracker) {
        this.involvedPluginsTracker = Assertions.notNull("pluginsInvolvedTracker", involvedPluginsTracker);
        this.i18nTranslationMode = Assertions.notNull("i18nTranslationMode", i18nTranslationMode);
        this.locale = Assertions.notNull("locale", locale);
        this.resourceBundlesInEffect = this.loadV1AndV2LanguagePacksAndPluginsBundles(locale);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public ResourceBundle getDefaultResourceBundle() {
        return DefaultResourceBundle.getDefaultResourceBundle(this.locale);
    }

    protected PluginAccessor getPluginAccessor() {
        return ComponentAccessor.getPluginAccessor();
    }

    @Override
    public Set<String> getKeysForPrefix(String prefix) {
        return this.prefixKeysCache.get(prefix);
    }

    @Override
    public String getUnescapedText(String key) {
        try {
            return this.getRawMsg(key);
        }
        catch (ResourceNotFound e) {
            return key;
        }
    }

    @Override
    public String getText(String key) {
        return this.formatI18nMsg(key, new Object[0]);
    }

    @Override
    public String getText(String key, String value1) {
        return this.formatI18nMsg(key, value1);
    }

    @Override
    public String getText(String key, String value1, String value2) {
        return this.formatI18nMsg(key, value1, value2);
    }

    @Override
    public String getText(String key, String value1, String value2, String value3) {
        return this.formatI18nMsg(key, value1, value2, value3);
    }

    @Override
    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.formatI18nMsg(key, value1, value2, value3);
    }

    @Override
    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.formatI18nMsg(key, value1, value2, value3, value4);
    }

    @Override
    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.formatI18nMsg(key, value1, value2, value3, value4);
    }

    @Override
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5);
    }

    @Override
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6);
    }

    @Override
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @Override
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @Override
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    @Override
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    @Override
    public String getText(String key, Object parameters) {
        Object[] substitutionParameters = parameters instanceof Object[] ? (Object[])parameters : (parameters instanceof Iterable ? Iterables.toArray((Iterable)((Iterable)parameters), Object.class) : (parameters == null ? new Object[]{} : this.asArray(parameters)));
        return this.formatI18nMsg(key, substitutionParameters);
    }

    private String formatI18nMsg(String key, Object ... substitutionParameters) {
        MessageFormat mf;
        String message;
        boolean doFormat;
        block5: {
            doFormat = true;
            try {
                message = this.getRawMsg(key);
            }
            catch (ResourceNotFound e) {
                message = key;
                doFormat = false;
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)String.format("Could not find i18n key: %s", key));
            }
        }
        if (!doFormat) {
            return this.hilightMsg(key, message, message);
        }
        try {
            mf = new MessageFormat(message, this.locale);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Error rendering '" + message + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        String formattedMsg = mf.format(substitutionParameters == null ? new Object[]{} : substitutionParameters);
        return this.hilightMsg(key, message, formattedMsg);
    }

    private String hilightMsg(String key, String rawMessage, String formattedMsg) {
        if (this.i18nTranslationMode.isTranslationMode()) {
            if (formattedMsg.equals(rawMessage)) {
                return String.format("%c%s%c%s%c%c", Character.valueOf('\ufeff'), formattedMsg, Character.valueOf('\u26a1'), key, Character.valueOf('\u26a1'), Character.valueOf('\u2060'));
            }
            return String.format("%c%s%c%s%c%s%c", Character.valueOf('\ufeff'), formattedMsg, Character.valueOf('\u26a1'), key, Character.valueOf('\u26a1'), rawMessage, Character.valueOf('\u2060'));
        }
        return formattedMsg;
    }

    private Object[] asArray(Object ... values) {
        return values == null ? new Object[]{} : values;
    }

    private String getRawMsg(String key) throws ResourceNotFound {
        if (key.startsWith("'") && key.endsWith("'")) {
            key = key.substring(1, key.length() - 1);
        }
        for (ResourceBundle bundle : this.resourceBundlesInEffect) {
            try {
                if (!bundle.containsKey(key)) continue;
                return bundle.getString(key);
            }
            catch (MissingResourceException ignored) {
            }
            catch (ClassCastException ignored) {
            }
            catch (NullPointerException ignored) {
            }
        }
        throw NOT_FOUND;
    }

    private Iterable<ResourceBundle> loadV1AndV2LanguagePacksAndPluginsBundles(Locale locale) {
        Iterable v1ClassPathJiraWebActionSupportBundles = Iterables.unmodifiableIterable(Collections.singletonList(this.getDefaultResourceBundle()));
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        if (pluginAccessor == null) {
            return v1ClassPathJiraWebActionSupportBundles;
        }
        Iterable<ResourceBundle> v2LanguagePackSourceBundles = this.loadV2LanguagePackBundles(locale, pluginAccessor);
        Iterable<ResourceBundle> pluginSourcedBundles = this.loadPluginSourcedBundles(locale, pluginAccessor);
        return Iterables.unmodifiableIterable((Iterable)Iterables.concat(v2LanguagePackSourceBundles, (Iterable)v1ClassPathJiraWebActionSupportBundles, pluginSourcedBundles));
    }

    private Iterable<ResourceBundle> loadV2LanguagePackBundles(Locale targetLocale, PluginAccessor pluginAccessor) {
        ArrayList<ResourceBundle> v2LanguagePacks = new ArrayList<ResourceBundle>();
        List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class);
        for (LanguageModuleDescriptor descriptor : descriptors) {
            String location = descriptor.getResourceBundleName();
            if (!((Language)descriptor.getModule()).getLocale().equals(targetLocale)) continue;
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(location, targetLocale, descriptor.getPlugin().getClassLoader());
                v2LanguagePacks.add(resourceBundle);
                this.involvedPluginsTracker.trackInvolvedPlugin(descriptor);
            }
            catch (MissingResourceException mre) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Failed to get resource bundle %s from module descriptor %s", location, descriptor.getName()), (Throwable)mre);
            }
        }
        return v2LanguagePacks;
    }

    private Iterable<ResourceBundle> loadPluginSourcedBundles(Locale targetLocale, PluginAccessor pluginAccessor) {
        ArrayList<ResourceBundle> pluginBundles = new ArrayList<ResourceBundle>();
        for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
            for (ResourceDescriptor resourceDescriptor : this.getResourceBundleLocations(plugin)) {
                try {
                    String location = resourceDescriptor.getLocation();
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(location, targetLocale, plugin.getClassLoader());
                    pluginBundles.add(resourceBundle);
                    this.involvedPluginsTracker.trackInvolvedPlugin(plugin);
                }
                catch (MissingResourceException mre) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Failed to get resource bundle %s from resource descriptor %s", resourceDescriptor.getLocation(), resourceDescriptor.getName()), (Throwable)mre);
                }
            }
        }
        return pluginBundles;
    }

    private Collection<ResourceDescriptor> getResourceBundleLocations(Plugin plugin) {
        ArrayList<ResourceDescriptor> locations = new ArrayList<ResourceDescriptor>();
        Iterables.addAll(locations, (Iterable)Iterables.filter((Iterable)plugin.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(PLUGIN_RESOURCE_TYPE_I18N)));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            Iterables.addAll(locations, (Iterable)Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(PLUGIN_RESOURCE_TYPE_I18N)));
        }
        return locations;
    }

    @Immutable
    static final class ResourceNotFound
    extends Exception {
        ResourceNotFound() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class PrefixFunction
    implements Function<String, Set<String>> {
        private PrefixFunction() {
        }

        public Set<String> apply(String prefix) {
            HashSet<String> ret = new HashSet<String>();
            for (ResourceBundle bundle : BackingI18n.this.resourceBundlesInEffect) {
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.startsWith(prefix)) continue;
                    ret.add(key);
                }
            }
            return Collections.unmodifiableSet(ret);
        }
    }
}

