/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util.navigator;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public enum IssueNavigatorType {
    SIMPLE,
    ADVANCED;


    public String getModeName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static IssueNavigatorType getFromCookie(HttpServletRequest request) {
        Cookie cookie;
        if (request != null && (cookie = IssueNavigatorType.getNavigatorTypeCookie(request)) != null) {
            return IssueNavigatorType.getTypeFromString(cookie.getValue());
        }
        return SIMPLE;
    }

    public static void setInCookie(HttpServletResponse response, IssueNavigatorType type) {
        Assertions.notNull("type", type);
        if (response != null) {
            Cookie cookie = new Cookie("jira.issue.navigator.type", type.name());
            cookie.setMaxAge(315360000);
            response.addCookie(cookie);
        }
    }

    public static void clearCookie(HttpServletRequest request) {
        Cookie cookie;
        if (request != null && (cookie = IssueNavigatorType.getNavigatorTypeCookie(request)) != null) {
            cookie.setValue(null);
        }
    }

    private static Cookie getNavigatorTypeCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"jira.issue.navigator.type".equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static IssueNavigatorType getTypeFromString(String name) {
        Assertions.notBlank("name", name);
        try {
            return IssueNavigatorType.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

