/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util.lists;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

public abstract class ListPager<T> {
    private final List<T> pagedList;
    private final int pageNo;
    private final int rowsPerPage;
    private final int fullListSize;
    private final int fromIndex;
    private final int toIndex;

    public ListPager(List<T> fullList, int pageNo, int rowsPerPage) {
        Assertions.notNull("fullList", fullList);
        Assertions.stateTrue("rowsPerPage must be greater than 0", rowsPerPage > 0);
        this.rowsPerPage = rowsPerPage;
        this.fullListSize = fullList.size();
        this.pageNo = Math.min(this.getEndPageNo(), Math.max(0, pageNo));
        int fromIndex = Math.min(this.fullListSize, this.pageNo * rowsPerPage);
        int toIndex = Math.min(this.fullListSize, fromIndex + rowsPerPage);
        this.pagedList = fromIndex == 0 && toIndex == this.fullListSize - 1 ? fullList : fullList.subList(fromIndex, toIndex);
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public String getPrevPageURL() {
        if (this.fromIndex <= 0) {
            return null;
        }
        return this.generatePageURL(this.pageNo - 1, this.rowsPerPage);
    }

    public String getNextPageURL() {
        if (this.toIndex + 1 >= this.fullListSize || !this.hasMultiplePages()) {
            return null;
        }
        return this.generatePageURL(this.pageNo + 1, this.rowsPerPage);
    }

    public String getStartPageURL() {
        if (!this.hasMultiplePages() || this.pageNo == 0) {
            return null;
        }
        return this.generatePageURL(0, this.rowsPerPage);
    }

    public String getEndPageURL() {
        int endPageNo = this.getEndPageNo();
        if (!this.hasMultiplePages() || this.pageNo >= endPageNo) {
            return null;
        }
        return this.generatePageURL(endPageNo, this.rowsPerPage);
    }

    private int getEndPageNo() {
        int endPageNo = 0;
        if (this.fullListSize > this.rowsPerPage) {
            int leftOver = this.fullListSize % this.rowsPerPage == 0 ? 0 : 1;
            endPageNo = this.fullListSize / this.rowsPerPage + leftOver - 1;
        }
        return endPageNo;
    }

    protected abstract String generatePageURL(int var1, int var2);

    public List<T> getList() {
        return this.pagedList;
    }

    public int getPageNumber() {
        return this.pageNo;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public int getFullListSize() {
        return this.fullListSize;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    public boolean hasMultiplePages() {
        return this.fullListSize > this.rowsPerPage;
    }
}

