/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.action.util.PopularIssueTypesUtil;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class PopularIssueTypesUtilImpl
implements PopularIssueTypesUtil {
    private static final Logger log = Logger.getLogger(PopularIssueTypesUtilImpl.class);
    private static final int POPULAR_ISSUE_TYPE_COUNT = 2;
    private static final String PERIOD_OF_CREATION = "-2w";
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public PopularIssueTypesUtilImpl(IssueTypeSchemeManager issueTypeSchemeManager, TranslationManager translationManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.translationManager = translationManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<IssueType> getPopularIssueTypesForProject(Project project, User user) {
        return this.getPopularAndOtherIssueTypesForProject(project, user).getPopularIssueTypes();
    }

    @Override
    public List<IssueType> getOtherIssueTypesForProject(Project project, User user) {
        return this.getPopularAndOtherIssueTypesForProject(project, user).getOtherIssueTypes();
    }

    @Override
    public PopularIssueTypesUtil.PopularIssueTypesHolder getPopularAndOtherIssueTypesForProject(Project project, User user) {
        Collection<IssueType> allTypes = this.issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project);
        Set<IssueType> types = this.getPopularIssueTypes(project, user, allTypes);
        int limit = 2;
        if (allTypes.size() == 3) {
            ++limit;
        }
        types = this.limitTypes(allTypes, types, limit);
        allTypes.removeAll(types);
        return new PopularIssueTypesUtil.PopularIssueTypesHolder(new ArrayList<IssueType>(types), new ArrayList<IssueType>(allTypes));
    }

    private Set<IssueType> limitTypes(Collection<IssueType> allTypes, Set<IssueType> types, int limit) {
        types = types.size() >= limit ? this.joinCollectionsWithLimit(types, Collections.<IssueType>emptyList(), limit) : this.joinCollectionsWithLimit(types, allTypes, limit);
        return types;
    }

    private Set<IssueType> getPopularIssueTypes(Project project, User user, Collection<IssueType> allTypes) {
        Set<IssueType> types = this.getPopularIssueTypesFromSearch(project, user, PERIOD_OF_CREATION);
        if ((types = this.removeSubtasks(types)).size() < 2 && types.size() != allTypes.size()) {
            types.addAll(this.removeSubtasks(this.getPopularIssueTypesFromSearch(project, user, null)));
        }
        if (user != null) {
            if (types.size() < 2 && types.size() != allTypes.size()) {
                types.addAll(this.removeSubtasks(this.getPopularIssueTypesFromSearch(project, null, PERIOD_OF_CREATION)));
            }
            if (types.size() < 2 && types.size() != allTypes.size()) {
                types.addAll(this.removeSubtasks(this.getPopularIssueTypesFromSearch(project, null, null)));
            }
        }
        return types;
    }

    Set<IssueType> getPopularIssueTypesFromSearch(Project project, User user, String period) {
        StatisticMapWrapper mapWrapper;
        SearchRequest sr = this.getSearchRequest(project, user, period);
        StatisticAccessorBean stats = new StatisticAccessorBean(null, sr, true);
        try {
            mapWrapper = stats.getAllFilterBy("issuetype", StatisticAccessorBean.OrderBy.TOTAL, StatisticAccessorBean.Direction.DESC);
        }
        catch (SearchException e) {
            log.error((Object)("Error trying to find popular issue types for project '" + project + "' and user '" + user + "'."), (Throwable)e);
            throw new RuntimeException(e);
        }
        return mapWrapper.keySet();
    }

    private Set<IssueType> getIssueTypesFromStatsMap(Collection issueTypeGVs) {
        LinkedHashSet<IssueType> types = new LinkedHashSet<IssueType>(issueTypeGVs.size());
        for (Object issueTypeGV : issueTypeGVs) {
            types.add(new IssueTypeImpl((GenericValue)issueTypeGV, this.translationManager, this.jiraAuthenticationContext));
        }
        return types;
    }

    private Set<IssueType> removeSubtasks(Collection<IssueType> types) {
        LinkedHashSet<IssueType> typesWithoutSubtasks = new LinkedHashSet<IssueType>(types.size());
        for (IssueType type : types) {
            if (type.isSubTask()) continue;
            typesWithoutSubtasks.add(type);
        }
        return typesWithoutSubtasks;
    }

    private SearchRequest getSearchRequest(Project project, User user, String period) {
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(project.getId());
        if (!StringUtils.isBlank((String)period)) {
            builder.and().createdAfter(period);
        }
        if (user != null && user.getName() != null) {
            builder.and().reporterUser(user.getName());
        }
        return new SearchRequest(builder.buildQuery());
    }

    private Set<IssueType> joinCollectionsWithLimit(Collection<IssueType> a, Collection<IssueType> b, int limit) {
        int i = 0;
        LinkedHashSet<IssueType> result = new LinkedHashSet<IssueType>(limit);
        for (IssueType type : a) {
            if (result.contains(type)) continue;
            result.add(type);
            if (++i < limit) continue;
            return result;
        }
        for (IssueType type : b) {
            if (result.contains(type)) continue;
            result.add(type);
            if (++i < limit) continue;
            return result;
        }
        return result;
    }
}

