/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jelly.JiraJelly;
import com.atlassian.jira.jelly.service.EmbededJellyContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import electric.xml.Document;
import electric.xml.ParseException;
import electric.xml.sax.SAXParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import webwork.util.TextUtil;

@WebSudoRequired
public class JellyRunner
extends JiraWebActionSupport {
    private static final String newLine = "<BR>";
    private static final Logger log = Logger.getLogger(JellyRunner.class);
    private String script = this.getDefaultString();
    private final StringWriter stringWriter = new StringWriter();
    private String filename = null;

    protected void doValidation() {
        File jellyFile;
        if (!TextUtils.stringSet((String)this.getScript()) && !TextUtils.stringSet((String)this.getFilename())) {
            this.addErrorMessage(this.getText("admin.errors.jellyrunner.provide.path"));
        } else if (TextUtils.stringSet((String)this.getScript()) && TextUtils.stringSet((String)this.getFilename())) {
            this.addErrorMessage(this.getText("admin.errors.jellyrunner.path.or.script"));
        } else if (!(!TextUtils.stringSet((String)this.getFilename()) || (jellyFile = new File(this.getFilename())).exists() && jellyFile.isFile() && jellyFile.canRead())) {
            this.addError("filename", this.getText("admin.errors.jellyrunner.file.does.not.exist"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isAllowedToRun()) {
            EmbededJellyContext embededJellyContext = new EmbededJellyContext();
            User remoteUser = this.getLoggedInUser();
            if (remoteUser != null) {
                embededJellyContext.setVariable("jelly.username", remoteUser.getName());
            }
            XMLOutput xmlOutput = XMLOutput.createXMLOutput((Writer)this.getStringWriter(), (boolean)false);
            XMLParser xmlParser = new XMLParser((XMLReader)new SAXParser());
            xmlParser.setContext((JellyContext)embededJellyContext);
            xmlParser.setValidating(true);
            try {
                Script script = this.getJellyScript(xmlParser);
                try {
                    Script compiledScript = script.compile();
                    try {
                        compiledScript.run((JellyContext)embededJellyContext, xmlOutput);
                    }
                    catch (JellyTagException e) {
                        this.addError(this.getText("admin.errors.could.not.run.script"), this.getStringWriter(), (Exception)((Object)e));
                    }
                    catch (RuntimeException e) {
                        this.addError(this.getText("admin.errors.exception") + " " + e.toString(), null, e);
                    }
                }
                catch (JellyException e) {
                    this.addError(this.getText("admin.errors.could.not.compile.script"), null, (Exception)((Object)e));
                }
            }
            catch (IOException e) {
                this.addError(this.getText("admin.errors.could.not.read.script.string"), null, e);
            }
            catch (SAXException e) {
                this.addError(this.getText("admin.errors.xml.script.invalid"), null, e);
            }
            if (this.invalidInput()) {
                return "error";
            }
            return "success";
        }
        this.addErrorMessage(this.getText("admin.errors.jellyrunner.not.on"));
        return "error";
    }

    private Script getJellyScript(XMLParser xmlParser) throws IOException, SAXException {
        Script script = TextUtils.stringSet((String)this.getScript()) ? xmlParser.parse((Reader)new StringReader(this.getScript())) : (TextUtils.stringSet((String)this.getFilename()) ? xmlParser.parse(new File(this.getFilename())) : null);
        return script;
    }

    public boolean isAllowedToRun() {
        return JiraJelly.allowedToRun();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = this.trimNullSafe(script);
    }

    @Override
    public String getResult() {
        String xmlOutputString = this.getStringWriter().toString().trim();
        if (xmlOutputString.length() > 0) {
            try {
                Document document = new Document(xmlOutputString);
                if (document.getRoot().hasChildNodes()) {
                    return TextUtils.plainTextToHtml((String)document.toString());
                }
                return null;
            }
            catch (ParseException e) {
                return "Output was not valid xml.<BR>" + TextUtils.plainTextToHtml((String)this.getStringWriter().toString());
            }
        }
        return null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String fileName) {
        this.filename = this.trimNullSafe(fileName);
    }

    private String trimNullSafe(String s) {
        return s == null ? null : s.trim();
    }

    private void addError(String message, StringWriter jellyOutput, Exception e) {
        String jellyOutputStr = "";
        if (jellyOutput != null) {
            jellyOutputStr = "<b>Error:</b> " + TextUtil.escapeHTML((String)jellyOutput.toString()) + newLine;
        }
        try {
            log.error((Object)message, (Throwable)e);
            this.addError("script", message);
            this.addError("scriptException", jellyOutputStr + "<b>Exception:</b> " + e.toString() + newLine + this.getStackTrace(e));
        }
        catch (Exception e1) {
            log.error((Object)("Exception adding error: " + e1), (Throwable)e1);
        }
    }

    private String getStackTrace(Exception e) {
        PrintWriter printWriter = new PrintWriter(new StringWriter());
        e.printStackTrace(printWriter);
        return printWriter.toString();
    }

    private StringWriter getStringWriter() {
        return this.stringWriter;
    }

    private String getDefaultString() {
        try {
            String script = "/jelly-defaultscript-ent.xml";
            return IOUtil.toString(JellyRunner.class.getResourceAsStream("/jelly-defaultscript-ent.xml"));
        }
        catch (Exception e) {
            log.error((Object)e);
            return "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n\n</JiraJelly>";
        }
    }
}

