/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.ImportTaskManager;
import com.atlassian.jira.task.ImportTaskManagerImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.DataImportAsyncCommand;
import com.atlassian.jira.web.action.util.ImportResultHandler;
import com.atlassian.jira.web.servletcontext.ServletContextReference;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.ServletContext;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

@WebSudoRequired
public class ImportAll
extends AbstractSetupAction {
    private static final String PROGRESS_URL = "/importprogress";
    private static ServletContextReference<ImportTaskManager> taskManagerReference = new ServletContextReference("jira.import.task.manager");
    private final IndexPathManager indexPathManager;
    private final JiraHome jiraHome;
    private final DataImportService dataImportService;
    private final ImportResultHandler importResultHandler;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private boolean quickImport;
    private String filename;
    private String licenseString;
    private boolean useDefaultPaths;
    private ErrorCollection specificErrors;

    public ImportAll(IndexPathManager indexPathManager, JiraHome jiraHome, FileFactory fileFactory, DataImportService dataImportService, ImportResultHandler importResultHandler, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(fileFactory);
        this.dataImportService = dataImportService;
        this.importResultHandler = importResultHandler;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.indexPathManager = Assertions.notNull("indexPathManager", indexPathManager);
        this.jiraHome = Assertions.notNull("jiraHome", jiraHome);
    }

    public String doDefault() throws Exception {
        ActionContext.getSession().remove("jira.data.import.result");
        return super.doDefault();
    }

    protected void doValidation() {
        DataImportParams params = new DataImportParams.Builder(this.filename).setLicenseString(this.licenseString).setUseDefaultPaths(this.useDefaultPaths).setQuickImport(this.quickImport).build();
        DataImportService.ImportValidationResult result = this.dataImportService.validateImport(this.getLoggedInUser(), params);
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doFinish() throws Exception {
        DataImportService.ImportResult lastResult = (DataImportService.ImportResult)ActionContext.getSession().get("jira.data.import.result");
        if (lastResult != null && !lastResult.isValid()) {
            try {
                this.filename = lastResult.getParams().getFilename();
                this.useDefaultPaths = lastResult.getParams().isUseDefaultPaths();
                this.quickImport = lastResult.getParams().isQuickImport();
                this.licenseString = lastResult.getParams().getLicenseString();
                this.addErrorCollection(lastResult.getErrorCollection());
                this.specificErrors = new SimpleErrorCollection();
                if (this.importResultHandler.handleErrorResult(ActionContext.getServletContext(), lastResult, this, this.specificErrors)) {
                    String string = this.getRedirect("/secure/errors.jsp");
                    return string;
                }
            }
            finally {
                ActionContext.getSession().remove("jira.data.import.result");
            }
            return "error";
        }
        return this.getRedirect("/secure/admin/XmlRestore!default.jspa");
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (taskManagerReference.get() != null && taskManagerReference.get().getTask() != null) {
            return this.getRedirect(this.getProgressUrl());
        }
        taskManagerReference.set(new ImportTaskManagerImpl());
        this.log.info((Object)"Running ImportAll");
        JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
        try {
            DataImportParams params = new DataImportParams.Builder(this.filename).setLicenseString(this.licenseString).setUseDefaultPaths(this.useDefaultPaths).setQuickImport(this.quickImport).build();
            DataImportService.ImportValidationResult result = this.dataImportService.validateImport(this.getLoggedInUser(), params);
            DataImportAsyncCommand importCallable = new DataImportAsyncCommand(eventCont, this.dataImportService, this.getLoggedInUser(), result, new Event(EventType.get((String)"import"), "JIRA is currently being restored from backup", EventLevel.get((String)"warning")), this.velocityRequestContextFactory.getJiraVelocityRequestContext(), ActionContext.getRequest().getSession(false));
            taskManagerReference.get().submitTask(importCallable, this.getText("admin.import.restore.jira.data.from.backup"));
            return this.getRedirect(this.getProgressUrl());
        }
        catch (AlreadyExecutingException e) {
            return this.getRedirect(this.getProgressUrl());
        }
        catch (RejectedExecutionException e) {
            this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
            return "error";
        }
    }

    private String getProgressUrl() {
        return "/importprogress?locale=" + this.getLocale().toString();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDefaultIndexPath() {
        return this.indexPathManager.getDefaultIndexRootPath();
    }

    public String getDefaultImportPath() {
        return this.jiraHome.getImportDirectory().getAbsolutePath();
    }

    public String getLicense() {
        return this.licenseString;
    }

    public void setLicense(String licenseString) {
        this.licenseString = licenseString;
    }

    public void setQuickImport(boolean quickImport) {
        this.quickImport = quickImport;
    }

    public boolean isUseDefaultPaths() {
        return this.useDefaultPaths;
    }

    public void setUseDefaultPaths(boolean useDefaultPaths) {
        this.useDefaultPaths = useDefaultPaths;
    }

    public boolean hasSpecificErrors() {
        return this.specificErrors != null && this.specificErrors.hasAnyErrors();
    }

    public ErrorCollection getSpecificErrors() {
        return this.specificErrors;
    }
}

