/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.StringUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

class DataCleaner {
    private static final Logger log = Logger.getLogger(DataCleaner.class);
    private ApplicationProperties applicationProperties;
    private OfBizDelegator ofBizDelegator;

    DataCleaner(ApplicationProperties applicationProperties, OfBizDelegator ofBizDelegator) {
        this.applicationProperties = applicationProperties;
        this.ofBizDelegator = ofBizDelegator;
    }

    void clean() throws DataAccessException {
        List<GenericValue> issues = this.ofBizDelegator.findAll("Issue");
        List<GenericValue> comments = this.ofBizDelegator.findByAnd("Action", EasyMap.build((Object)"type", (Object)"comment"));
        for (GenericValue issue : issues) {
            this.escapeField(issue, "summary");
            this.escapeField(issue, "environment");
            this.escapeField(issue, "description");
            List<GenericValue> changeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", EasyMap.build((Object)"issue", (Object)issue.getLong("id")), Arrays.asList("created"));
            for (GenericValue changeGroup : changeGroups) {
                for (GenericValue changeItem : this.ofBizDelegator.getRelated("ChildChangeItem", changeGroup)) {
                    this.escapeField(changeItem, "oldstring");
                    this.escapeField(changeItem, "newstring");
                }
            }
        }
        for (GenericValue comment : comments) {
            this.escapeField(comment, "body");
        }
        List<GenericValue> customFieldValues = this.ofBizDelegator.findAll("CustomFieldValue");
        for (GenericValue customFieldValue : customFieldValues) {
            this.escapeField(customFieldValue, "stringvalue");
        }
        List<GenericValue> changeItems = this.ofBizDelegator.findAll("ChangeItem");
        for (GenericValue changeItem : changeItems) {
            this.escapeField(changeItem, "oldstring");
            this.escapeField(changeItem, "newstring");
        }
    }

    private String getEncoding() {
        try {
            return this.applicationProperties.getEncoding();
        }
        catch (Exception e) {
            return "UTF-8";
        }
    }

    private String escapeString(String s) {
        return StringUtils.escapeCP1252((String)s, (String)this.getEncoding());
    }

    private void escapeField(GenericValue gv, String fieldName) {
        String escapedValue;
        String fieldValue = gv.getString(fieldName);
        if (TextUtils.stringSet((String)fieldValue) && !fieldValue.equals(escapedValue = this.escapeString(fieldValue))) {
            gv.set(fieldName, (Object)this.escapeString(fieldValue));
            try {
                CoreFactory.getGenericDelegator().storeAll(Arrays.asList(gv));
            }
            catch (GenericEntityException e) {
                log.error((Object)("Error storing entity " + gv + " while escaping field " + fieldName), (Throwable)e);
            }
        }
    }
}

