/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class CalendarLanguageUtilImpl
implements CalendarLanguageUtil {
    private static final Logger log = Logger.getLogger(CalendarLanguageUtilImpl.class);
    private static final String PROPS_FILENAME = "calendar-language-util.properties";
    private static final CalendarLanguageUtil instance = new CalendarLanguageUtilImpl();
    private final Map<String, String> mappings = CalendarLanguageUtilImpl.load("calendar-language-util.properties");

    public static CalendarLanguageUtil getInstance() {
        return instance;
    }

    @Override
    public boolean hasTranslationForLanguage(String language) {
        return language != null && this.mappings.containsKey(language);
    }

    @Override
    public String getCalendarFilenameForLanguage(String language) {
        return language == null || !this.mappings.containsKey(language) ? null : this.mappings.get(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> load(String name) {
        Properties mappings = new Properties();
        InputStream is = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)name, CalendarLanguageUtilImpl.class);
            mappings.load(is);
        }
        catch (IOException e) {
            log.warn((Object)"Unable to load the calendar-language-util.properties file");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : CollectionUtil.transform(mappings.keySet(), Functions.downcast(String.class))) {
            builder.put((Object)key, (Object)mappings.getProperty(key));
        }
        return builder.build();
    }
}

