/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.web.action.user.ViewProfile;
import com.opensymphony.util.TextUtils;

public abstract class GenericEditProfile
extends ViewProfile {
    String fullName;
    String email;

    public GenericEditProfile(UserPropertyManager userPropertyManager) {
        super(userPropertyManager);
    }

    public abstract User getEditedUser();

    public String doDefault() throws Exception {
        this.fullName = this.getEditedUser().getDisplayName();
        this.email = this.getEditedUser().getEmailAddress();
        return super.doDefault();
    }

    protected void doValidation() {
        this.log.debug((Object)("fullName = " + this.fullName));
        this.log.debug((Object)("email = " + this.email));
        if (!TextUtils.stringSet((String)TextUtils.noNull((String)this.fullName).trim())) {
            this.addError("fullName", this.getText("admin.errors.invalid.full.name.specified"));
        }
        if (!TextUtils.verifyEmail((String)TextUtils.noNull((String)this.email).trim())) {
            this.addError("email", this.getText("admin.errors.invalid.email"));
        }
    }

    @Override
    protected String doExecute() throws Exception {
        UserTemplate user = new UserTemplate(this.getEditedUser());
        user.setDisplayName(this.fullName);
        user.setEmailAddress(this.email);
        try {
            this.crowdService.updateUser((User)user);
        }
        catch (OperationNotPermittedException e) {
            this.addErrorMessage(this.getText("admin.errors.cannot.edit.user.directory.read.only"));
        }
        catch (OperationFailedException e) {
            this.addErrorMessage(this.getText("admin.editprofile.error.occurred", e.getMessage()));
        }
        return this.getResult();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

