/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EditDarkFeatures
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger(EditDarkFeatures.class);
    private FeatureManager featureManager;
    private String featureKey;
    private String action;

    public EditDarkFeatures(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Override
    public String execute() throws Exception {
        String feature = this.featureKey.trim();
        if (StringUtils.isNotEmpty((String)feature)) {
            User user = this.getLoggedInUser();
            try {
                if ("remove".equals(this.action)) {
                    this.featureManager.disableUserDarkFeature(user, feature);
                    log.info((Object)("User '" + user.getName() + "' disabled Dark Feature '" + feature + "'"));
                } else {
                    this.featureManager.enableUserDarkFeature(user, feature);
                    log.warn((Object)("User '" + user.getName() + "' enabled Dark Feature '" + feature + "'"));
                }
            }
            catch (IllegalStateException e) {
                log.warn((Object)("User '" + user.getName() + "' attempted to change Core Feature '" + feature + "'. This feature may only be changed site-wide."));
            }
        }
        return this.forceRedirect("ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-darkfeatures-panel");
    }

    public void setFeatureKey(String featureKey) {
        this.featureKey = featureKey;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

