/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class ContactAdministrators
extends JiraWebActionSupport {
    private static final String EMAIL_TEMPLATES = "templates/email";
    private static final String EMAIL_TEMPLATE = "contactadministrator.vm";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final Integer PADSIZE = 20;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final WebResourceManager webResourceManager;
    private final RendererManager rendererManager;
    private final MailQueue mailQueue;
    private final UserUtil userUtil;
    private String to;
    private String from;
    private String subject;
    private String details;

    public ContactAdministrators(RendererManager rendererManager, MailQueue mailQueue, UserUtil userUtil, WebResourceManager webResourceManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.rendererManager = rendererManager;
        this.mailQueue = mailQueue;
        this.userUtil = userUtil;
        this.webResourceManager = webResourceManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.to = this.getText("admin.global.permissions.administer");
        if (this.getLoggedInUser() != null) {
            this.from = this.getLoggedInUser().getEmailAddress();
        }
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (StringUtils.isEmpty((String)this.from) || !TextUtils.verifyEmail((String)this.from)) {
            this.addError("from", this.getText("admin.errors.must.specify.valid.from.address"));
        }
        if (StringUtils.isEmpty((String)this.subject)) {
            this.addError("subject", this.getText("admin.errors.must.specify.subject"));
        }
        if (StringUtils.isEmpty((String)this.details)) {
            this.addError("details", this.getText("admin.errors.must.specify.request.details"));
        }
    }

    protected String doExecute() throws Exception {
        this.send();
        return this.getRedirect("/secure/MyJiraHome.jspa");
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean getSendEmail() {
        if (!JiraMailUtils.isHasMailServer()) {
            return false;
        }
        return this.getApplicationProperties().getOption("jira.show.contact.administrators.form");
    }

    public String getRenderedMessage() {
        String message = this.getApplicationProperties().getDefaultBackedText("jira.contact.administrators.message");
        if (StringUtils.isEmpty((String)message) && !this.getSendEmail()) {
            message = this.getText("admin.generalconfiguration.contact.administrators.message.default");
        }
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    public void send() throws MailException {
        Collection<User> administrators = this.userUtil.getJiraAdministrators();
        for (User administrator : administrators) {
            this.sendTo(administrator);
        }
    }

    private void sendTo(User administrator) throws MailException {
        if (!JiraMailUtils.isHasMailServer()) {
            return;
        }
        try {
            HashMap<String, Object> velocityParams = new HashMap<String, Object>();
            velocityParams.put("content", this.details);
            velocityParams.put("i18n", new I18nBean(administrator));
            velocityParams.put("webResourceManager", this.webResourceManager);
            velocityParams.put("baseurl", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
            velocityParams.put("urlModeAbsolute", UrlMode.ABSOLUTE);
            velocityParams.put("padSize", PADSIZE);
            VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(ComponentAccessor.getApplicationProperties()).getJiraVelocityRequestContext();
            String body = ComponentAccessor.getVelocityManager().getEncodedBody(this.getTemplateDirectory(administrator), EMAIL_TEMPLATE, ENCODING_UTF8, velocityParams);
            com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(administrator.getEmailAddress());
            email.setFrom(this.from);
            email.setSubject(this.subject);
            email.setMimeType(this.getMimeType(administrator));
            email.setEncoding(ENCODING_UTF8);
            email.setBody(body);
            this.mailQueue.addItem((MailQueueItem)new SingleMailQueueItem((Email)email));
        }
        catch (Exception e) {
            this.log.error((Object)"Error sending JIRA Administrator email", (Throwable)e);
        }
    }

    private String getTemplateDirectory(User to) {
        return "templates/email/" + this.getFormat(to) + "/";
    }

    private String getMimeType(User to) {
        if (this.getFormat(to).equals("html")) {
            return "text/html";
        }
        return "text/plain";
    }

    public String getFormat(User user) {
        JiraUserPreferences userPrefs = new JiraUserPreferences(user);
        String prefFormat = userPrefs.getString("user.notifications.mimetype");
        if (TextUtils.stringSet((String)prefFormat) && (prefFormat.equals("html") || prefFormat.equals("text"))) {
            return prefFormat;
        }
        return "text";
    }
}

