/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.issue.comparator.PortalPageNameComparator;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.user.UserProfileAction;
import com.atlassian.jira.web.bean.ShareTypeRendererBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AddPortalPage
extends JiraWebActionSupport
implements UserProfileAction {
    private static final String SHARES_FIELD = "shares";
    private final PortalPageService portalPageService;
    private final ShareTypeFactory shareTypeFactory;
    private final JiraAuthenticationContext authCtx;
    private final PermissionManager permissionsManager;
    private final EmailFormatter emailFormatter;
    private final GroupPermissionChecker groupPermissionChecker;
    private final UserSharingPreferencesUtil userSharingPreferencesUtil;
    private final UserHistoryManager userHistoryManager;
    private String portalPageDescription = null;
    private String portalPageName = null;
    private String shareString = null;
    private SharedEntity.SharePermissions sharePermissions = SharedEntity.SharePermissions.PRIVATE;
    private List types = null;
    private boolean favourite = true;
    private Long clonePageId = null;
    private PortalPage clonePage = null;
    private Collection clonedTargetPages = null;

    public AddPortalPage(PortalPageService portalPageService, ShareTypeFactory shareTypeFactory, UserSharingPreferencesUtil userSharingPreferencesUtil, JiraAuthenticationContext authCtx, PermissionManager permissionsManager, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker, UserHistoryManager userHistoryManager) {
        this.portalPageService = portalPageService;
        this.shareTypeFactory = shareTypeFactory;
        this.authCtx = authCtx;
        this.permissionsManager = permissionsManager;
        this.emailFormatter = emailFormatter;
        this.groupPermissionChecker = groupPermissionChecker;
        this.userSharingPreferencesUtil = userSharingPreferencesUtil;
        this.userHistoryManager = userHistoryManager;
    }

    public String doDefault() {
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (this.isEditEnabled()) {
            this.setPermissions(this.userSharingPreferencesUtil.getDefaultSharePermissions(this.getLoggedInUser()));
        }
        if (this.clonePageId != null && this.getClonePage() == null) {
            this.addErrorMessage(this.getText("addportalpage.clone.does.not.exist"));
            return "error";
        }
        return "input";
    }

    protected void doValidation() {
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (StringUtils.isNotBlank((String)this.shareString)) {
            try {
                SharedEntity.SharePermissions permissions = SharePermissionUtils.fromJsonArrayString(this.shareString);
                this.setPermissions(permissions);
            }
            catch (JSONException e) {
                this.log.error((Object)("Unable to parse the returned SharePermissions: " + e.getMessage()), (Throwable)e);
                this.addError(SHARES_FIELD, this.getText("common.sharing.parse.error"));
                return;
            }
        }
        JiraServiceContext servceCtx = this.getJiraServiceContext();
        PortalPage newPortalPage = this.createNewPortalPage();
        if (this.clonePageId != null) {
            this.portalPageService.validateForCreatePortalPageByClone(servceCtx, newPortalPage, this.clonePageId);
        } else {
            this.portalPageService.validateForCreate(servceCtx, newPortalPage);
        }
    }

    protected String doExecute() {
        JiraServiceContext servceCtx = this.getJiraServiceContext();
        PortalPage newPortalPage = this.clonePageId != null ? this.clonePortalPage(servceCtx, this.clonePageId) : this.createBlankPortalPage(servceCtx);
        if (newPortalPage != null) {
            if (this.favourite) {
                this.userHistoryManager.addItemToHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser(), String.valueOf(newPortalPage.getId()));
                return this.getRedirect("ConfigurePortalPages!default.jspa#view=favourite");
            }
            return this.getRedirect("ConfigurePortalPages!default.jspa#view=my");
        }
        return "error";
    }

    public String getPortalPageDescription() {
        return this.portalPageDescription;
    }

    public void setPortalPageDescription(String portalPageDescription) {
        this.portalPageDescription = StringUtils.isNotBlank((String)portalPageDescription) ? portalPageDescription : null;
    }

    public Collection<PortalPage> getCloneTargetDashboardPages() {
        if (this.clonedTargetPages == null) {
            PortalPage portalPage2;
            HashSet<Long> clonePageIds = new HashSet<Long>();
            PortalPage systemDefaultPortalPage = this.portalPageService.getSystemDefaultPortalPage();
            clonePageIds.add(systemDefaultPortalPage.getId());
            Collection<PortalPage> favouritePortalPages = this.portalPageService.getFavouritePortalPages(this.getLoggedInUser());
            ArrayList<PortalPage> clonePages = new ArrayList<PortalPage>(favouritePortalPages.size() + 1);
            for (PortalPage portalPage2 : favouritePortalPages) {
                if (!clonePageIds.add(portalPage2.getId())) continue;
                clonePages.add(portalPage2);
            }
            Collection<PortalPage> myPages = this.portalPageService.getOwnedPortalPages(this.getLoggedInUser());
            for (PortalPage portalPage3 : myPages) {
                if (!clonePageIds.add(portalPage3.getId())) continue;
                clonePages.add(portalPage3);
            }
            if (this.clonePageId != null && !clonePageIds.contains(this.clonePageId) && (portalPage2 = this.getClonePage()) != null) {
                clonePages.add(portalPage2);
            }
            Collections.sort(clonePages, new PortalPageNameComparator());
            clonePages.add(0, systemDefaultPortalPage);
            this.clonedTargetPages = Collections.unmodifiableCollection(clonePages);
        }
        return this.clonedTargetPages;
    }

    public String getPortalPageName() {
        return this.portalPageName;
    }

    public void setPortalPageName(String portalPageName) {
        this.portalPageName = portalPageName;
    }

    public void setShareValues(String values) {
        this.shareString = values;
    }

    private void setPermissions(SharedEntity.SharePermissions sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    private SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public void setFavourite(boolean favourite) {
        this.favourite = favourite;
    }

    public Long getClonePageId() {
        return this.clonePageId;
    }

    public void setClonePageId(Long clonePageId) {
        this.clonePageId = clonePageId;
    }

    public Collection getShareTypes() {
        if (this.types == null) {
            Collection<ShareType> sharesTypes = this.shareTypeFactory.getAllShareTypes();
            this.types = new ArrayList(sharesTypes.size());
            for (ShareType shareType : sharesTypes) {
                this.types.add(new ShareTypeRendererBean(shareType, this.authCtx, ShareTypeRenderer.RenderMode.EDIT, PortalPage.ENTITY_TYPE));
            }
        }
        return this.types;
    }

    public boolean showShares() {
        return this.isEditEnabled() || !this.getPermissions().isEmpty();
    }

    public boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.getLoggedInUser());
    }

    public String getJsonString() {
        ArrayList<SharePermission> sortedShares = new ArrayList<SharePermission>(this.getPermissions().getPermissionSet());
        Collections.sort(sortedShares, this.shareTypeFactory.getPermissionComparator());
        try {
            return SharePermissionUtils.toJsonArray(sortedShares).toString();
        }
        catch (JSONException e) {
            this.log.error((Object)("Unable to create JSON representation of shares: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private PortalPage getClonePage() {
        if (this.clonePageId != null && this.clonePage == null) {
            JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getLoggedInUser(), new SimpleErrorCollection());
            this.clonePage = this.portalPageService.getPortalPage(ctx, this.clonePageId);
        }
        return this.clonePage;
    }

    private PortalPage createBlankPortalPage(JiraServiceContext serviceContext) {
        PortalPage newPortalPage = this.createNewPortalPage();
        if (this.portalPageService.validateForCreate(serviceContext, newPortalPage)) {
            return this.portalPageService.createPortalPage(serviceContext, newPortalPage, this.favourite);
        }
        return null;
    }

    private PortalPage clonePortalPage(JiraServiceContext serviceContext, Long clonePortalPageId) {
        PortalPage newPortalPage = this.createNewPortalPage();
        if (this.portalPageService.validateForCreatePortalPageByClone(serviceContext, newPortalPage, clonePortalPageId)) {
            return this.portalPageService.createPortalPageByClone(serviceContext, newPortalPage, clonePortalPageId, this.favourite);
        }
        return null;
    }

    private PortalPage createNewPortalPage() {
        User user = this.getLoggedInUser();
        String userName = user != null ? user.getName() : null;
        return PortalPage.name(this.portalPageName).description(this.portalPageDescription).owner(userName).permissions(this.getPermissions()).build();
    }

    @Override
    public boolean isHasViewGroupPermission(String group, User user) {
        return this.groupPermissionChecker.hasViewGroupPermission(group, user);
    }

    @Override
    public String getDisplayEmail(String email) {
        return this.emailFormatter.formatEmailAsLink(email, this.getLoggedInUser());
    }

    @Override
    public User getUser() {
        return this.getLoggedInUser();
    }
}

