/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.JiraPermission;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SetupOldUserHelper {
    private static final String OSUSER_ENTITY = "OSUser";
    private static final String OSUSER_ID = "id";
    private static final String OSUSER_NAME = "name";
    private static final String OSUSER_PASSWORD_HASH = "passwordHash";
    private static final String OSGROUP_ENTITY = "OSGroup";
    private static final String OSGROUP_ID = "id";
    private static final String OSGROUP_NAME = "name";
    private static final String OSMEMBERSHIP_ENTITY = "OSMembership";
    private static final String OSMEMBERSHIP_ID = "id";
    private static final String OSMEMBERSHIP_GROUPNAME = "groupName";
    private static final String OSMEMBERSHIP_USERNAME = "userName";

    public static GenericValue addUser(UserService.CreateUserValidationResult result) throws GenericEntityException {
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        List currentuser = genericDelegator.findByAnd(OSUSER_ENTITY, EasyMap.build((Object)"name", (Object)result.getUsername()));
        if (currentuser != null && currentuser.size() > 0) {
            return (GenericValue)currentuser.get(0);
        }
        PasswordEncoderFactory passwordEncoderFactory = ComponentManager.getComponentInstanceOfType(PasswordEncoderFactory.class);
        String hash = passwordEncoderFactory.getEncoder("atlassian-security").encodePassword(result.getPassword(), null);
        GenericValue user = genericDelegator.create(OSUSER_ENTITY, EasyMap.build((Object)"id", (Object)genericDelegator.getNextSeqId(OSUSER_ENTITY), (Object)"name", (Object)result.getUsername(), (Object)OSUSER_PASSWORD_HASH, (Object)hash));
        JiraPropertySetFactory jiraPropertySetFactory = ComponentManager.getComponentInstanceOfType(JiraPropertySetFactory.class);
        PropertySet ps = jiraPropertySetFactory.buildNoncachingPropertySet(OSUSER_ENTITY, user.getLong("id"));
        ps.setString("fullName", result.getFullname());
        ps.setString("email", result.getEmail());
        return user;
    }

    public static boolean groupExists(String groupName) throws GenericEntityException {
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        List currentuser = genericDelegator.findByAnd(OSGROUP_ENTITY, EasyMap.build((Object)"name", (Object)groupName));
        return currentuser != null && currentuser.size() > 0;
    }

    public static GenericValue addGroup(String groupName) throws GenericEntityException {
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        List currentuser = genericDelegator.findByAnd(OSGROUP_ENTITY, EasyMap.build((Object)"name", (Object)groupName));
        if (currentuser != null && currentuser.size() > 0) {
            return (GenericValue)currentuser.get(0);
        }
        return genericDelegator.create(OSGROUP_ENTITY, EasyMap.build((Object)"id", (Object)genericDelegator.getNextSeqId(OSGROUP_ENTITY), (Object)"name", (Object)groupName));
    }

    public static GenericValue addToGroup(String groupName, String userName) throws GenericEntityException {
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        List currentuser = genericDelegator.findByAnd(OSMEMBERSHIP_ENTITY, EasyMap.build((Object)OSMEMBERSHIP_GROUPNAME, (Object)groupName, (Object)OSMEMBERSHIP_USERNAME, (Object)userName));
        if (currentuser != null && currentuser.size() > 0) {
            return (GenericValue)currentuser.get(0);
        }
        return genericDelegator.create(OSMEMBERSHIP_ENTITY, EasyMap.build((Object)"id", (Object)genericDelegator.getNextSeqId(OSMEMBERSHIP_ENTITY), (Object)OSMEMBERSHIP_GROUPNAME, (Object)groupName, (Object)OSMEMBERSHIP_USERNAME, (Object)userName));
    }

    public static GenericValue getExistingAdmins() throws GenericEntityException {
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        Collection<JiraPermission> jiraPermissions = ManagerFactory.getGlobalPermissionManager().getPermissions(0);
        for (JiraPermission jiraPermission : jiraPermissions) {
            List currentuser = genericDelegator.findByAnd(OSMEMBERSHIP_ENTITY, EasyMap.build((Object)OSMEMBERSHIP_GROUPNAME, (Object)jiraPermission.getGroup()));
            if (currentuser == null || currentuser.size() <= 0) continue;
            return (GenericValue)currentuser.get(0);
        }
        return null;
    }
}

