/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.DatabaseList;
import com.atlassian.core.util.PairType;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.IndexLanguageToLocaleMapper;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SetupDatabase
extends AbstractSetupAction {
    private static final int DEFAULT_POOL_SIZE = 15;
    private boolean testingConnection;
    private final BuildUtilsInfo buildUtilsInfo;
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final ApplicationProperties applicationProperties;
    private final IndexLanguageToLocaleMapper languageToLocaleMapper;
    private String language;
    private boolean changingLanguage;
    private String databaseOption = "INTERNAL";
    private String databaseType;
    private String schemaName;
    private static final Map<String, String> SCHEMA_NAMES = ImmutableMap.of((Object)"postgres72", (Object)"public", (Object)"mssql", (Object)"dbo");
    private String jdbcHostname;
    private String jdbcPort;
    private String jdbcDatabase;
    private String jdbcSid;
    private String jdbcUsername;
    private String jdbcPassword;
    private Integer poolSize = 15;
    private DatabaseList databaseList = new DatabaseList();
    private boolean isTestConnectionSuccessful;
    private static final Map<String, DatabaseType> databaseTypeMap = MapBuilder.newBuilder().add("oracle10g", DatabaseType.ORACLE).add("postgres72", DatabaseType.POSTGRES).add("mysql", DatabaseType.MY_SQL).add("mssql", DatabaseType.SQL_SERVER).toMap();

    public SetupDatabase(FileFactory fileFactory, IndexLanguageToLocaleMapper languageToLocaleMapper, BuildUtilsInfo buildUtilsInfo, DatabaseConfigurationManager databaseConfigurationManager, ApplicationProperties applicationProperties) {
        super(fileFactory);
        this.languageToLocaleMapper = languageToLocaleMapper;
        this.buildUtilsInfo = buildUtilsInfo;
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.applicationProperties = applicationProperties;
    }

    public String doInput() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return "input";
    }

    public String doDefault() {
        if (this.isDatabaseSetup()) {
            return this.forceRedirect("Setup!input.jspa?title=Your+Company+JIRA&mode=public");
        }
        return "input";
    }

    protected void doValidation() {
        if (this.setupAlready() || this.isChangingLanguage()) {
            return;
        }
        if (this.isExternalDatabase()) {
            if ("".equals(this.databaseType)) {
                this.addError("databaseType", this.getText("setupdb.error.selectDatabaseType"));
            }
            if (StringUtils.isEmpty((String)this.jdbcHostname)) {
                this.addError("jdbcHostname", this.getText("setupdb.error.requireJdbcHostname"));
            }
            if (StringUtils.isEmpty((String)this.jdbcPort)) {
                this.addError("jdbcPort", this.getText("setupdb.error.requireJdbcPort"));
            }
            if (this.isOracleDatabaseType()) {
                if (StringUtils.isEmpty((String)this.jdbcSid)) {
                    this.addError("jdbcSid", this.getText("setupdb.error.requireSID"));
                }
            } else if (StringUtils.isEmpty((String)this.jdbcDatabase)) {
                this.addError("jdbcDatabase", this.getText("setupdb.error.requireDatabase"));
            }
            if (StringUtils.isEmpty((String)this.jdbcUsername)) {
                this.addError("jdbcUsername", this.getText("setupdb.error.requireJdbcUsername"));
            }
        }
        this.testConnection();
        this.validateDatabaseIsEmpty();
        super.doValidation();
    }

    private boolean isOracleDatabaseType() {
        return "oracle10g".equals(this.databaseType);
    }

    private boolean isExternalDatabase() {
        return "EXTERNAL".equals(this.databaseOption);
    }

    private void testConnection() {
        if (!this.hasAnyErrors()) {
            try {
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                StartupCheck startupCheck = databaseConfiguration.testConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());
                if (startupCheck != null) {
                    this.addErrorMessage(startupCheck.getFaultDescription());
                }
            }
            catch (BootstrapException e) {
                this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                Throwable cause = e.getCause();
                this.addErrorMessage(cause.getLocalizedMessage());
                if (cause.getCause() != null && !cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) {
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            catch (IllegalArgumentException e) {
                this.addErrorMessage(this.getText("setupdb.error.invalidDriver") + e.getCause().getLocalizedMessage());
            }
            this.isTestConnectionSuccessful = this.isTestingConnection() && !this.hasAnyErrors();
        }
    }

    private void validateDatabaseIsEmpty() {
        if (!this.hasAnyErrors()) {
            boolean isDatabaseEmpty;
            block4: {
                isDatabaseEmpty = false;
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                try {
                    isDatabaseEmpty = databaseConfiguration.isDatabaseEmpty(new DefaultAtlassianBootstrapManager());
                }
                catch (BootstrapException e) {
                    this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                    Throwable cause = e.getCause();
                    this.addErrorMessage(cause.getLocalizedMessage());
                    if (cause.getCause() == null || cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) break block4;
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            if (!isDatabaseEmpty) {
                this.addErrorMessage(this.getText("setupdb.error.nonemptyDatabase"));
            }
            this.isTestConnectionSuccessful = this.isTestingConnection() && !this.hasAnyErrors();
        }
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.isDatabaseSetup()) {
            return this.forceRedirect("Setup!input.jspa?title=Your+Company+JIRA&mode=public");
        }
        if (this.isChangingLanguage()) {
            this.setLanguage();
            return "input";
        }
        if (this.isTestingConnection()) {
            return this.hasAnyErrors() ? "error" : "input";
        }
        DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
        this.databaseConfigurationManager.setDatabaseConfiguration(databaseConfiguration);
        this.databaseConfigurationManager.activateDatabase();
        return this.forceRedirect("Setup!input.jspa?title=Your+Company+JIRA&mode=public");
    }

    private DatabaseConfig createDatabaseConfiguration() {
        if (this.isExternalDatabase()) {
            DatabaseDetails databaseDetails = this.getDatabaseDetails(this.databaseType);
            this.poolSize = databaseDetails.getPoolSize();
            String instanceName = this.isOracleDatabaseType() ? this.jdbcSid : this.jdbcDatabase;
            DatabaseType type = this.getDatabaseTypeEnum();
            String validationQuery = type == DatabaseType.MY_SQL ? "select 1" : null;
            Long minEvictableTimeMillis = null;
            Long timeBetweenEvictionRunsMillis = null;
            if (type == DatabaseType.HSQL) {
                minEvictableTimeMillis = 4000L;
                timeBetweenEvictionRunsMillis = 5000L;
            }
            JdbcDatasource datasource = new JdbcDatasource(type, this.jdbcHostname, this.jdbcPort, instanceName, this.jdbcUsername, this.jdbcPassword, this.poolSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis);
            return new DatabaseConfig(this.databaseType, this.schemaName, datasource);
        }
        return this.databaseConfigurationManager.getInternalDatabaseConfiguration();
    }

    public boolean isDatabaseConnectionTestWorked() {
        return this.isTestConnectionSuccessful;
    }

    public boolean isDatabaseSetup() {
        return this.databaseConfigurationManager.isDatabaseSetup();
    }

    public Collection<Locale> getInstalledLocales() {
        return ComponentAccessor.getComponentOfType(LocaleManager.class).getInstalledLocales();
    }

    public List<PairType> getExternalDatabases() {
        PairType defaultSelect = new PairType((Serializable)((Object)""), (Serializable)((Object)this.getText("setupdb.database.selectType")));
        ArrayList<PairType> selectList = new ArrayList<PairType>();
        selectList.add(defaultSelect);
        selectList.addAll(this.databaseList.getDatabases());
        return selectList;
    }

    public DatabaseDetails getDatabaseDetails(String database) {
        try {
            return DatabaseDetails.getDefaults((String)database);
        }
        catch (ConfigurationException e) {
            this.log.debug((Object)e);
            return null;
        }
    }

    public String getSchemaName(String database) {
        return SCHEMA_NAMES.get(database);
    }

    public String getDefaultServerLanguage() {
        if (this.getInstalledLocales().contains(this.applicationProperties.getDefaultLocale())) {
            return this.applicationProperties.getDefaultLocale().toString();
        }
        return "en_UK";
    }

    private void setLanguage() {
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        if (TextUtils.stringSet((String)this.getLanguage())) {
            applicationProperties.setString("jira.i18n.default.locale", this.getLanguage());
        }
        applicationProperties.setString("jira.i18n.language.index", this.languageToLocaleMapper.getLanguageForLocale(this.getLocale().toString()));
    }

    private DatabaseType getDatabaseTypeEnum() {
        DatabaseType type = databaseTypeMap.get(this.databaseType);
        if (type == null) {
            throw new IllegalStateException("Unknown database type '" + this.databaseType + "'");
        }
        return type;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseOption() {
        return this.databaseOption;
    }

    public void setDatabaseOption(String databaseOption) {
        this.databaseOption = databaseOption;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public int modulo(int index, int modulus) {
        return index % modulus;
    }

    public boolean isTestingConnection() {
        return this.testingConnection;
    }

    public void setTestingConnection(boolean testingConnection) {
        this.testingConnection = testingConnection;
    }

    public String getJdbcHostname() {
        return this.jdbcHostname;
    }

    public void setJdbcHostname(String jdbcHostname) {
        this.jdbcHostname = jdbcHostname;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcPort() {
        return this.jdbcPort;
    }

    public void setJdbcPort(String jdbcPort) {
        this.jdbcPort = jdbcPort;
    }

    public String getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    public void setJdbcDatabase(String jdbcDatabase) {
        this.jdbcDatabase = jdbcDatabase;
    }

    public String getJdbcSid() {
        return this.jdbcSid;
    }

    public void setJdbcSid(String jdbcSid) {
        this.jdbcSid = jdbcSid;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isChangingLanguage() {
        return this.changingLanguage;
    }

    public void setChangingLanguage(boolean changingLanguage) {
        this.changingLanguage = changingLanguage;
    }
}

