/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.plugin.event.PluginEventManager;
import java.util.Collection;
import java.util.List;
import webwork.action.ActionContext;

public class SetupComplete
extends AbstractSetupAction {
    private final UpgradeManager upgradeManager;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final JiraLicenseService licenseService;
    private final SubTaskManager subTaskManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final PluginEventManager pluginEventManager;

    public SetupComplete(UpgradeManager upgradeManager, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser, JiraLicenseService licenseService, SubTaskManager subTaskManager, FieldLayoutManager fieldLayoutManager, FileFactory fileFactory, PluginEventManager pluginEventManager) {
        super(fileFactory);
        this.pluginEventManager = Assertions.notNull("pluginEventManager", pluginEventManager);
        this.licenseService = Assertions.notNull("licenseService", licenseService);
        this.upgradeManager = Assertions.notNull("upgradeManager", upgradeManager);
        this.licenseJohnsonEventRaiser = Assertions.notNull("licenseJohnsonEventRaiser", licenseJohnsonEventRaiser);
        this.subTaskManager = Assertions.notNull("subTaskManager", subTaskManager);
        this.fieldLayoutManager = Assertions.notNull("fieldLayoutManager", fieldLayoutManager);
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        this.getApplicationProperties().setString("jira.setup", "true");
        this.initialiseSystemPropertiesBeforeSetupUpgradeTasks();
        if (this.licenseTooOld()) {
            return this.getRedirect("/secure/errors.jsp");
        }
        Collection<String> errors = this.upgradeManager.doSetupUpgrade();
        if (!errors.isEmpty()) {
            for (String error : errors) {
                this.addErrorMessage(error);
            }
        } else {
            this.initialiseSystemPropertiesAfterSetupUpgradeTasks();
            this.pluginEventManager.broadcast((Object)new JiraStartedEvent());
        }
        return this.possibleDevModeRedirect(this.getResult());
    }

    private String possibleDevModeRedirect(String result) {
        DevModeSecretSauce setupHelper = new DevModeSecretSauce();
        String redirect = setupHelper.redirectUrlOnSetupComplete(result);
        return !result.equals(redirect) ? this.forceRedirect(redirect) : result;
    }

    private void initialiseSystemPropertiesBeforeSetupUpgradeTasks() {
        this.getApplicationProperties().setOption("jira.option.allowunassigned", false);
        this.getApplicationProperties().setOption("jira.option.user.externalmanagement", false);
        this.getApplicationProperties().setOption("jira.option.voting", true);
        this.getApplicationProperties().setOption("jira.option.watching", true);
        this.getApplicationProperties().setOption("jira.option.issuelinking", true);
        this.getApplicationProperties().setString("jira.option.emailvisible", "show");
    }

    private void initialiseSystemPropertiesAfterSetupUpgradeTasks() {
        this.enableSubTasks();
        this.setWikiRendererOnAllRenderableFields();
    }

    private void enableSubTasks() {
        try {
            this.subTaskManager.enableSubTasks();
        }
        catch (CreateException e) {
            this.log.error((Object)"Error encountered when trying to enable sub tasks", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void setWikiRendererOnAllRenderableFields() {
        EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
        List<FieldLayoutItem> fieldLayoutItems = editableDefaultFieldLayout.getFieldLayoutItems();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            RenderableField field;
            if (!(fieldLayoutItem.getOrderableField() instanceof RenderableField) || !(field = (RenderableField)((Object)fieldLayoutItem.getOrderableField())).isRenderable()) continue;
            editableDefaultFieldLayout.setRendererType(fieldLayoutItem, "atlassian-wiki-renderer");
        }
        this.fieldLayoutManager.storeEditableDefaultFieldLayout(editableDefaultFieldLayout);
    }

    protected boolean licenseTooOld() {
        return this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild(ActionContext.getServletContext(), this.licenseService.getLicense());
    }

    public String doDefault() throws Exception {
        return this.doExecute();
    }
}

