/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.projectcategory;

import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

@WebSudoRequired
public class AddProjectCategory
extends ProjectActionSupport {
    private final ProjectManager projectManager;
    public String name;
    public String description;

    public AddProjectCategory(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.errors.please.specify.a.name"));
            return;
        }
        Collection<ProjectCategory> projectCategories = this.projectManager.getAllProjectCategories();
        if (projectCategories != null) {
            for (ProjectCategory projectCategory : projectCategories) {
                if (!this.name.equalsIgnoreCase(projectCategory.getName())) continue;
                this.addError("name", this.getText("admin.errors.project.category.already.exists", "'" + this.name + "'"));
                break;
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            this.projectManager.createProjectCategory(this.getName(), this.getDescription());
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.projectcategory.could.not.create", e));
            return "error";
        }
        return this.getRedirect("ViewProjectCategories!default.jspa");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

