/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ViewProjects
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public ViewProjects(UserUtil userUtil, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    protected String doExecute() throws Exception {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        session.removeAttribute("atl.jira.admin.current.project");
        session.removeAttribute("atl.jira.admin.current.project.tab");
        return super.doExecute();
    }

    public boolean isAdmin() throws GenericEntityException {
        return ComponentAccessor.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public boolean isProjectAdmin(GenericValue project) throws GenericEntityException {
        return ComponentAccessor.getPermissionManager().hasPermission(23, project, this.getLoggedInUser());
    }

    public boolean hasAdminPermission(GenericValue project) throws GenericEntityException {
        return ComponentAccessor.getPermissionManager().hasPermission(0, project, this.getLoggedInUser());
    }

    public List getProjects() {
        ArrayList<GenericValue> returns = new ArrayList<GenericValue>();
        Collection<GenericValue> projects = ComponentAccessor.getProjectManager().getProjects();
        for (GenericValue project : projects) {
            if (!ComponentAccessor.getPermissionManager().hasPermission(23, project, this.getLoggedInUser()) && !ComponentAccessor.getPermissionManager().hasPermission(0, this.getLoggedInUser())) continue;
            returns.add(project);
        }
        return returns;
    }

    public boolean isDefaultAssigneeAssignable(GenericValue project) throws GenericEntityException {
        Long assigneeType = project.getLong("assigneetype");
        if (assigneeType == null) {
            return true;
        }
        if (2L == assigneeType) {
            return ComponentUtils.isProjectLeadAssignable(project);
        }
        return true;
    }

    public String abbreviateString(String str, int length) {
        return StringUtils.abbreviate((String)str, (int)length);
    }

    public User getUser(GenericValue project) {
        return this.userUtil.getUser(project.getString("lead"));
    }

    public boolean getStringSet(GenericValue gv, String value) {
        return TextUtils.stringSet((String)gv.getString(value));
    }

    public String getPrettyAssigneeType(Long assigneeType) {
        return ProjectAssigneeTypes.getPrettyAssigneeType(assigneeType);
    }

    public boolean isAllowSignUp() {
        return this.userManager.hasPasswordWritableDirectory() && JiraUtils.isPublicMode();
    }
}

