/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.popups;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Map;

public class ShowTimeTrackingHelp
extends JiraWebActionSupport {
    private ApplicationProperties applicationProperties;

    public ShowTimeTrackingHelp(ApplicationProperties applicationProperties, WorklogService worklogService, IssueService issueService) {
        this.applicationProperties = applicationProperties;
    }

    public boolean isCommentCopiedToWorkDescription() {
        return this.applicationProperties.getOption("jira.timetracking.copy.comment.to.work.desc.on.transition");
    }

    public String getDefaultTimeUnit() {
        Map<String, String> map = MapBuilder.newBuilder().add(DateUtils.Duration.MINUTE.name(), this.getText("core.dateutils.minute")).add(DateUtils.Duration.HOUR.name(), this.getText("core.dateutils.hour")).add(DateUtils.Duration.DAY.name(), this.getText("core.dateutils.day")).add(DateUtils.Duration.WEEK.name(), this.getText("core.dateutils.week")).toMap();
        return map.get(this.applicationProperties.getString("jira.timetracking.default.unit"));
    }

    public String getDaysPerWeek() {
        return this.applicationProperties.getString("jira.timetracking.days.per.week");
    }

    public String getHoursPerDay() {
        return this.applicationProperties.getString("jira.timetracking.hours.per.day");
    }
}

