/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.navigator;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ParameterStore;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class DateRangePicker
extends JiraWebActionSupport {
    private static final int SECONDS_IN_DAY = 86400;
    private static final String TYPE_OVERDUE = "TYPE_OVERDUE";
    private static final String END_DATE_DAYS_AGO = "END_DATE_DAYS_AGO";
    private static final String TYPE_DUEINNEXT = "TYPE_DUEINNEXT";
    private static final String TYPE_GENERIC = "TYPE_GENERIC";
    private static final String AND_OVERDUE = "AND";
    private static final String AND_NOT_OVERDUE = "AND_NOT";
    private static final String START_DATE_IN_PAST = "START_DATE_IN_PAST";
    private static final String START_DATE_DAYS_AGO = "START_DATE_DAYS_AGO";
    private static final String FIELD_NAME_FIELD_ID = "fieldId";
    private static final String FIELD_NAME_FORM_NAME = "formName";
    private static final String FIELD_NAME_NEXT_FIELD_NAME = "nextFieldName";
    private static final String FIELD_NAME_PREVIOUS_FIELD_NAME = "previousFieldName";
    private static final String KEY_FIELD_INVALID = "popups.daterange.field.invalid";
    private static final String KEY_FIELD_NOT_SET = "popups.daterange.field.not.set";
    private String formName;
    private String fieldId;
    private String fieldName;
    private String previousFieldName;
    private String nextFieldName;
    private String previousFieldValue;
    private String nextFieldValue;
    private String andOverdue;
    private String dueInNext;
    private String selectedType = "TYPE_GENERIC";
    private String endDateDaysAgo;
    private String startDateDaysAgo;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldManager fieldManager;

    public DateRangePicker(JiraAuthenticationContext authenticationContext, FieldManager fieldManager) {
        this.authenticationContext = authenticationContext;
        this.fieldManager = fieldManager;
    }

    protected void doValidation() {
        super.doValidation();
        if (this.isSetAndNotEmpty(FIELD_NAME_FIELD_ID, this.fieldId)) {
            String fieldId = this.getFieldId();
            if (!this.isCustomField() && this.fieldManager.getField(fieldId) == null) {
                this.addErrorMessage(this.getText(KEY_FIELD_INVALID, fieldId));
            }
        }
        this.isSetAndNotEmpty(FIELD_NAME_FORM_NAME, this.formName);
        this.isSetAndNotEmpty(FIELD_NAME_NEXT_FIELD_NAME, this.nextFieldName);
        this.isSetAndNotEmpty(FIELD_NAME_PREVIOUS_FIELD_NAME, this.previousFieldName);
    }

    private boolean isSetAndNotEmpty(String name, String value) {
        boolean setAndNotEmpty;
        boolean bl = setAndNotEmpty = value != null && value.length() > 0;
        if (!setAndNotEmpty) {
            this.addErrorMessage(this.getText(KEY_FIELD_NOT_SET, name));
        }
        return setAndNotEmpty;
    }

    protected String doExecute() throws Exception {
        long previousVal;
        long nextValDays;
        long nextVal;
        if (this.isCustomField()) {
            CustomField customField = this.fieldManager.getCustomField(this.getFieldId());
            this.setFieldName(customField.getName());
        } else {
            Field field = this.fieldManager.getField(this.getFieldId());
            this.setFieldName(field.getName());
        }
        if (StringUtils.isEmpty((String)this.getPreviousFieldValue()) && StringUtils.isEmpty((String)this.getNextFieldValue())) {
            return this.getResult();
        }
        try {
            nextVal = DateUtils.getDurationWithNegative((String)this.getNextFieldValue());
            nextValDays = nextVal / 86400L;
            previousVal = DateUtils.getDurationWithNegative((String)this.getPreviousFieldValue());
        }
        catch (InvalidDurationException e) {
            this.previousFieldValue = "";
            this.nextFieldValue = "";
            this.log.debug((Object)"Invalid parameters passed from the caller page. Ignoring them...");
            return this.getResult();
        }
        if (!this.isDueDate() && StringUtils.isNotEmpty((String)this.getPreviousFieldValue()) && this.isSelectListValue(previousVal)) {
            this.selectedType = START_DATE_IN_PAST;
            this.previousFieldValue = DateUtils.getDurationStringWithNegative((long)previousVal);
            return this.getResult();
        }
        if (!this.isDueDate() && StringUtils.isNotEmpty((String)this.getPreviousFieldValue()) && previousVal < 0L && this.isDayValue(previousVal)) {
            this.selectedType = START_DATE_DAYS_AGO;
            this.startDateDaysAgo = String.valueOf(-previousVal / 86400L);
            return this.getResult();
        }
        if (StringUtils.isEmpty((String)this.getPreviousFieldValue()) && StringUtils.isNotEmpty((String)this.getNextFieldValue())) {
            if (nextVal == 0L && this.isDueDate()) {
                this.setNextFieldValue("");
                this.selectedType = TYPE_OVERDUE;
                return this.getResult();
            }
            if (nextVal < 0L && this.isDayValue(nextVal)) {
                this.setNextFieldValue("");
                this.selectedType = END_DATE_DAYS_AGO;
                this.endDateDaysAgo = "" + -nextValDays;
                return this.getResult();
            }
        }
        if (nextVal > 0L && this.isDayValue(nextVal)) {
            if (StringUtils.isEmpty((String)this.getPreviousFieldValue())) {
                this.setNextFieldValue("");
                this.setAndOverdue(AND_OVERDUE);
                this.selectedType = TYPE_DUEINNEXT;
                this.dueInNext = "" + nextValDays;
                return this.getResult();
            }
            if (previousVal == 0L) {
                this.setNextFieldValue("");
                this.setPreviousFieldValue("");
                this.setAndOverdue(AND_NOT_OVERDUE);
                this.selectedType = TYPE_DUEINNEXT;
                this.dueInNext = "" + nextValDays;
                return this.getResult();
            }
        }
        this.selectedType = TYPE_GENERIC;
        return this.getResult();
    }

    public boolean isCustomField() {
        return this.fieldManager.isCustomField(this.getFieldId());
    }

    private boolean isSelectListValue(long previousVal) {
        Collection timePeriods = this.getTimePeriods();
        for (Option option : timePeriods) {
            try {
                long optionValue = DateUtils.getDurationWithNegative((String)option.getId());
                if (optionValue != previousVal) continue;
                return true;
            }
            catch (InvalidDurationException e) {
                throw new IllegalArgumentException("Option " + option.getId() + " is not a valid period. Fix up the ParameterStire code");
            }
        }
        return false;
    }

    private boolean isDayValue(long nextVal) {
        return nextVal % 86400L == 0L;
    }

    @Override
    public String getResult() {
        if (this.isDueDate()) {
            return "duedate";
        }
        return "generic";
    }

    private boolean isDueDate() {
        return "duedate".equals(this.fieldId);
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getEndDateDaysAgo() {
        return this.endDateDaysAgo;
    }

    public String getDueInNext() {
        return this.dueInNext;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getPreviousFieldName() {
        return this.previousFieldName;
    }

    public void setPreviousFieldName(String previousFieldName) {
        this.previousFieldName = previousFieldName;
    }

    public String getNextFieldName() {
        return this.nextFieldName;
    }

    public void setNextFieldName(String nextFieldName) {
        this.nextFieldName = nextFieldName;
    }

    public String getPreviousFieldValue() {
        return this.previousFieldValue;
    }

    public void setPreviousFieldValue(String previousFieldValue) {
        this.previousFieldValue = previousFieldValue;
    }

    public String getNextFieldValue() {
        return this.nextFieldValue;
    }

    public void setNextFieldValue(String nextFieldValue) {
        this.nextFieldValue = nextFieldValue;
    }

    public String getSelectedType() {
        return this.selectedType;
    }

    public String getAndOverdue() {
        return this.andOverdue;
    }

    public void setAndOverdue(String andOverdue) {
        this.andOverdue = andOverdue;
    }

    public String getStartDateDaysAgo() {
        return this.startDateDaysAgo;
    }

    public void setStartDateDaysAgo(String startDateDaysAgo) {
        this.startDateDaysAgo = startDateDaysAgo;
    }

    public Collection getTimePeriods() {
        ParameterStore parameterStore = new ParameterStore(this.authenticationContext.getLoggedInUser());
        return parameterStore.getTimePeriods();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

