/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.ActionNames;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.UpdateFieldsHelperBean;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.dispatcher.ActionResult;

public class UpdateFieldsHelperBeanImpl
implements UpdateFieldsHelperBean {
    private static final Logger log = Logger.getLogger(UpdateFieldsHelperBeanImpl.class);
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private FieldScreenRendererFactory fieldScreenRendererFactory;

    public UpdateFieldsHelperBeanImpl(PermissionManager permissionManager, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext, FieldScreenRendererFactory fieldScreenRendererFactory) {
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
    }

    @Override
    public ActionResult updateIssue(MutableIssue issueObject, OperationContext operationContext, User user, ErrorCollection errors, I18nHelper i18n) throws Exception {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(user, issueObject);
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                OrderableField orderableField;
                if (!fieldScreenRenderLayoutItem.isShow(issueObject) || !fieldValuesHolder.containsKey((orderableField = fieldScreenRenderLayoutItem.getOrderableField()).getId())) continue;
                orderableField.updateIssue(fieldScreenRenderLayoutItem.getFieldLayoutItem(), issueObject, fieldValuesHolder);
            }
        }
        Map newActionParams = EasyMap.build((Object)"issue", (Object)issueObject.getGenericValue(), (Object)"issueObject", (Object)issueObject, (Object)"remoteUser", (Object)user);
        return CoreFactory.getActionDispatcher().execute(ActionNames.ISSUE_UPDATE, newActionParams);
    }

    @Override
    public void validate(Issue issueObject, OperationContext operationContext, Map actionParams, User user, ErrorCollection errors, I18nHelper i18n) {
        if (!this.isEditable(issueObject)) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("editissue.error.no.edit.permission"));
            return;
        }
        FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(user, issueObject);
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                OrderableField orderableField;
                if (!fieldScreenRenderLayoutItem.isShow(issueObject) || !actionParams.containsKey((orderableField = fieldScreenRenderLayoutItem.getOrderableField()).getId())) continue;
                orderableField.populateFromParams(operationContext.getFieldValuesHolder(), actionParams);
                orderableField.validateParams(operationContext, errors, i18n, issueObject, fieldScreenRenderLayoutItem);
            }
        }
    }

    public boolean isEditable(Issue issue) {
        if (issue == null) {
            throw new IssueNotFoundException("Issue unexpectedly null");
        }
        boolean hasPermission = this.permissionManager.hasPermission(12, issue, this.authenticationContext.getLoggedInUser());
        if (hasPermission) {
            return issue.isEditable();
        }
        return false;
    }

    @Override
    public List getFieldsForEdit(User user, Issue issueObject) {
        ArrayList<OrderableField> fields = new ArrayList<OrderableField>();
        FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(user, issueObject);
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                if (!fieldScreenRenderLayoutItem.isShow(issueObject)) continue;
                fields.add(fieldScreenRenderLayoutItem.getOrderableField());
            }
        }
        return fields;
    }

    @Override
    public boolean isFieldValidForEdit(User user, String fieldId, Issue issueObject) {
        if (fieldId != null) {
            FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(user, issueObject);
            for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    if (!fieldScreenRenderLayoutItem.isShow(issueObject) || !fieldId.equals(fieldScreenRenderLayoutItem.getOrderableField().getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private FieldScreenRenderer getFieldScreenRenderer(User user, Issue issueObject) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issueObject, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, false);
    }
}

