/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import org.apache.log4j.Logger;

final class SearchActionHelper {
    private static final Logger log = Logger.getLogger(SearchActionHelper.class);
    private static final int DEFAULT_NUMBER_OF_ISSUES_PER_PAGE = 20;
    private final SessionPagerFilterManager sessionPagerFilterManager;
    private final Preferences userPreferences;
    private int tempMax = -1;

    SearchActionHelper(SessionPagerFilterManager sessionPagerFilterManager, Preferences userPreferences, IssueSearchLimits issueSearchLimits) {
        this.sessionPagerFilterManager = Assertions.notNull("sessionPagerFilterManager", sessionPagerFilterManager);
        this.userPreferences = Assertions.notNull("userPreferences", userPreferences);
    }

    PagerFilter getPagerFilter() {
        PagerFilter pager = (PagerFilter)this.sessionPagerFilterManager.getCurrentObject();
        if (pager == null) {
            pager = this.resetPager();
        }
        if (this.tempMax >= 0) {
            pager.setMax(this.tempMax);
        }
        return pager;
    }

    PagerFilter resetPager() {
        PagerFilter pager = new PagerFilter();
        try {
            pager.setMax((int)this.userPreferences.getLong("user.issues.per.page"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Unable to find 'user.issues.per.page' property setting. Defaulting to 20");
            pager.setMax(20);
        }
        this.sessionPagerFilterManager.setCurrentObject(pager);
        return pager;
    }

    int getTempMax() {
        return this.tempMax;
    }

    void setTempMax(int tempMax) {
        this.tempMax = tempMax;
    }

    void resetPagerTempMax() {
        if (this.getTempMax() >= 0) {
            this.getPagerFilter().setMax(this.getTempMax());
        }
    }

    void restartPager() {
        this.getPagerFilter().setStart(0);
    }
}

