/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.security.IssueSecurityHelper;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;

public class MoveIssueUpdateFields
extends MoveIssue
implements OperationContext {
    private MutableIssue targetIssue;
    private final IssueSecurityHelper issueSecurityHelper;

    public MoveIssueUpdateFields(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueSecurityHelper issueSecurityHelper, UserUtil userUtil) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
        this.issueSecurityHelper = issueSecurityHelper;
    }

    @Override
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        MutableIssue originalIssue = this.getIssueObject(this.getIssue());
        MutableIssue targetIssue = this.getTargetIssueObject();
        if (!ActionContext.getSingleValueParameters().containsKey("reset") || !"true".equals(ActionContext.getSingleValueParameters().get("reset"))) {
            LinkedList<FieldLayoutItem> moveFieldLayoutItems = new LinkedList<FieldLayoutItem>();
            FieldLayout targetFieldLayout = this.getTargetFieldLayout();
            for (FieldLayoutItem fieldLayoutItem : targetFieldLayout.getVisibleLayoutItems(this.getLoggedInUser(), this.getTargetProjectObj(), EasyList.build((Object)this.getTargetIssueType()))) {
                OrderableField orderableField = fieldLayoutItem.getOrderableField();
                if ("issuetype".equals(orderableField.getId()) || !orderableField.needsMove(EasyList.build((Object)originalIssue), targetIssue, fieldLayoutItem).getResult()) continue;
                if (orderableField.isShown(targetIssue)) {
                    orderableField.populateForMove(this.getMoveIssueBean().getFieldValuesHolder(), originalIssue, targetIssue);
                }
                moveFieldLayoutItems.add(fieldLayoutItem);
            }
            this.getMoveIssueBean().setMoveFieldLayoutItems(moveFieldLayoutItems);
        }
        this.validateAttachmentMove();
        if (this.isSubTask()) {
            this.getMoveIssueBean().setCurrentStep(2);
            this.getMoveIssueBean().addAvailablePreviousStep(3);
        } else {
            this.getMoveIssueBean().setCurrentStep(3);
            this.getMoveIssueBean().addAvailablePreviousStep(2);
        }
        return "input";
    }

    public Collection getMoveFieldLayoutItems() {
        return this.getMoveIssueBean().getMoveFieldLayoutItems();
    }

    protected MutableIssue getTargetIssueObject() {
        if (this.targetIssue == null) {
            this.targetIssue = this.getTargetIssueObjectWithSecurityLevel();
            if (this.issueSecurityHelper.securityLevelNeedsMove(this.getIssueObject(), this.targetIssue)) {
                this.targetIssue.setSecurityLevel(null);
            }
        }
        return this.targetIssue;
    }

    protected MutableIssue getTargetIssueObjectWithSecurityLevel() {
        MutableIssue targetIssue = this.getIssueManager().getIssueObject(this.getId());
        targetIssue.setProject(this.getTargetProject());
        targetIssue.setIssueType(this.getTargetIssueTypeGV());
        return targetIssue;
    }

    protected FieldLayout getTargetFieldLayout() {
        return this.getFieldLayoutManager().getFieldLayout(this.getTargetProject(), this.getTargetIssueType());
    }

    public String getFieldHtml(FieldLayoutItem fieldLayoutItem) {
        MutableIssue targetIssue;
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        if (orderableField.isShown(targetIssue = this.getTargetIssueObject())) {
            return orderableField.getCreateHtml(fieldLayoutItem, this.getMoveIssueBean(), (Action)this, targetIssue);
        }
        return "";
    }

    public String getFieldName(Field field) {
        if (field instanceof CustomField) {
            return field.getName();
        }
        return this.getText(field.getNameKey());
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            try {
                if (!this.isHasIssuePermission(25, this.getIssue())) {
                    this.addErrorMessage(this.getText("moveissue.no.permission"));
                }
                MutableIssue targetIssue = this.getTargetIssueObject();
                for (FieldLayoutItem fieldLayoutItem : this.getMoveFieldLayoutItems()) {
                    OrderableField orderableField = fieldLayoutItem.getOrderableField();
                    if (orderableField.isShown(targetIssue)) {
                        this.populateFromParams(orderableField);
                        orderableField.validateParams(this.getMoveIssueBean(), this, this, targetIssue, new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                        continue;
                    }
                    this.popluateDefault(orderableField);
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    orderableField.validateParams(this.getMoveIssueBean(), errorCollection, this, targetIssue, new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                    if (errorCollection.getErrors() != null && !errorCollection.getErrors().isEmpty()) {
                        Iterator<String> iterator1 = errorCollection.getErrors().values().iterator();
                        while (iterator1.hasNext()) {
                            this.addErrorMessage(this.getFieldName(orderableField) + ": " + iterator1.next());
                        }
                    }
                    this.addErrorMessages(errorCollection.getErrorMessages());
                }
            }
            catch (Exception e) {
                this.addErrorMessage(this.getText("admin.errors.issues.error.occurred.validating.field", e));
            }
        }
    }

    protected void popluateDefault(OrderableField orderableField) {
        orderableField.populateDefaults(this.getMoveIssueBean().getFieldValuesHolder(), this.getTargetIssueObject());
    }

    protected void populateFromParams(OrderableField orderableField) {
        orderableField.populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
    }

    @Override
    public String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        MutableIssue targetIssue = this.getTargetIssueObjectWithSecurityLevel();
        for (FieldLayoutItem fieldLayoutItem : this.getMoveFieldLayoutItems()) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            orderableField.updateIssue(fieldLayoutItem, targetIssue, this.getMoveIssueBean().getFieldValuesHolder());
        }
        LinkedList<OrderableField> removedFields = new LinkedList<OrderableField>();
        for (Field field : this.getTargetHiddenFields()) {
            if (field == null || !this.getFieldManager().isOrderableField(field)) continue;
            boolean doValueCheck = this.isShouldCheckFieldValue(this.getIssueObject(), field);
            OrderableField orderableField = (OrderableField)field;
            if (!doValueCheck || !orderableField.hasValue(targetIssue) || !orderableField.canRemoveValueFromIssueObject(targetIssue)) continue;
            orderableField.removeValueFromIssueObject(targetIssue);
            removedFields.add(orderableField);
        }
        this.getMoveIssueBean().setRemovedFields(removedFields);
        this.getMoveIssueBean().setUpdatedIssue(targetIssue);
        return "success";
    }

    protected boolean isShouldCheckFieldValue(Issue origIssue, Field field) {
        boolean doValueCheck = true;
        List issueTypeList = EasyList.build((Object)origIssue.getIssueTypeObject().getId());
        if (this.fieldManager.isCustomField(field) && !((CustomField)field).isInScope(origIssue.getProjectObject(), (List<String>)issueTypeList)) {
            doValueCheck = false;
        }
        return doValueCheck;
    }

    protected Collection getTargetHiddenFields() {
        return this.getTargetFieldLayout().getHiddenFields(this.getLoggedInUser(), this.getTargetProject(), (List<String>)EasyList.build((Object)this.getTargetIssueType()));
    }

    public Map getCustomFieldValuesHolder() {
        return this.getMoveIssueBean().getFieldValuesHolder();
    }

    protected Collection getCurrentCustomFieldObjects(String issueTypeId) {
        return this.getCustomFieldManager().getCustomFieldObjects(this.getProject().getLong("id"), issueTypeId);
    }

    protected Collection getTargetCustomFieldObjects(String targetIssueTypeId) {
        return this.getCustomFieldManager().getCustomFieldObjects(this.getTargetPid(), targetIssueTypeId);
    }

    public Collection getTargetCustomFields() {
        return this.getTargetCustomFieldObjects(this.getTargetIssueType());
    }

    protected Collection getInvalidCustomFields(String currentIssueTypeId, String targetIssueTypeId) {
        ArrayList<CustomField> invalidCustomFields = new ArrayList<CustomField>();
        Collection targetCustomFields = this.getTargetCustomFieldObjects(targetIssueTypeId);
        for (CustomField currentCustomField : this.getCurrentCustomFieldObjects(currentIssueTypeId)) {
            if (targetCustomFields.contains(currentCustomField)) continue;
            invalidCustomFields.add(currentCustomField);
        }
        return invalidCustomFields;
    }
}

