/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueSearchLimitsImpl
implements IssueSearchLimits {
    private final Logger log = LoggerFactory.getLogger(IssueSearchLimitsImpl.class);
    private final ApplicationProperties applicationProperties;

    public IssueSearchLimitsImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public int getMaxResults() {
        try {
            String defaultMax = this.applicationProperties.getDefaultBackedString("jira.search.views.default.max");
            if (StringUtils.isBlank((String)defaultMax)) {
                return 1000;
            }
            return Integer.valueOf(defaultMax);
        }
        catch (NumberFormatException e) {
            this.log.warn("Cannot get issue navigator restriction clause for: {} key={}", (Object)this.applicationProperties.getDefaultBackedString("jira.search.views.default.max"), (Object)"jira.search.views.default.max");
            return 1000;
        }
    }
}

