/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.issue.CreateIssue;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;

public class CreateSubTaskIssue
extends CreateIssue {
    private final ConstantsManager constantsManager;
    private final IssueManager issueManager;
    private Long parentIssueId;

    public CreateSubTaskIssue(ConstantsManager constantsManager, IssueManager issueManager, IssueCreationHelperBean issueCreationHelperBean, IssueFactory issueFactory) {
        super(issueFactory, issueCreationHelperBean);
        this.constantsManager = constantsManager;
        this.issueManager = issueManager;
        this.getIgnoreFieldIds().add("security");
    }

    @Override
    protected String getRedirectForCreateBypass() {
        return this.forceRedirect("CreateSubTaskIssue.jspa?parentIssueId=" + this.getParentIssueId() + "&pid=" + this.getPid() + "&issuetype=" + this.getIssuetype());
    }

    boolean prepareFieldsIfOneOption() {
        MutableIssue parent = this.issueManager.getIssueObject(this.parentIssueId);
        if (parent == null) {
            return false;
        }
        if (this.getAllowedProjects().isEmpty()) {
            return false;
        }
        Project project = parent.getProjectObject();
        Collection issueTypes = this.getIssueTypesForProject(project);
        if (issueTypes.size() == 1) {
            IssueType issueType = (IssueType)issueTypes.iterator().next();
            this.setPid(project.getId());
            this.getFieldValuesHolder().put("project", project.getId());
            this.setIssuetype(issueType.getId());
            this.getFieldValuesHolder().put("issuetype", issueType.getId());
            return true;
        }
        return false;
    }

    @Override
    protected void setHistoryIssuetype() {
        String historySubTaskIssueType = (String)ActionContext.getSession().get("jira.user.history.subtask.issuetype");
        this.setIssuetype(historySubTaskIssueType);
        this.getFieldValuesHolder().put("issuetype", historySubTaskIssueType);
    }

    @Override
    protected void recordHistoryIssueType() {
        ActionContext.getSession().put("jira.user.history.subtask.issuetype", this.getIssuetype());
    }

    @Override
    protected void validateIssueType() {
        this.getIssueObject().setParentId(this.getParentIssueId());
        this.issueCreationHelperBean.validateIssueType(this.getIssueObject(), this, ActionContext.getParameters(), this, this);
    }

    public Collection getIssueTypes() {
        return this.constantsManager.getSubTaskIssueTypes();
    }

    public Long getParentIssueId() {
        return this.parentIssueId;
    }

    public void setParentIssueId(Long parentIssueId) {
        this.parentIssueId = parentIssueId;
    }

    @Override
    public MutableIssue getIssueObject() {
        if (this.getIssueObjectWithoutDatabaseRead() == null) {
            MutableIssue issue = super.getIssueObject();
            issue.setParentId(this.getParentIssueId());
            issue.setProject(this.getProject());
        }
        return this.getIssueObjectWithoutDatabaseRead();
    }

    @Override
    public Long getPid() {
        Long parentIssueId = this.getParentIssueId();
        MutableIssue issue = this.issueManager.getIssueObject(parentIssueId);
        if (issue != null) {
            return issue.getLong("project");
        }
        this.log.error((Object)("Issue with id '" + parentIssueId + "' does not exist or could not be retrieved."));
        return null;
    }

    public String getParentIssueKey() {
        Issue parentIssue = this.getParentIssue();
        if (parentIssue != null) {
            return parentIssue.getKey();
        }
        return null;
    }

    public String getParentIssuePath() {
        return "/browse/" + this.getParentIssueKey();
    }

    private Issue getParentIssue() {
        return this.getIssueManager().getIssueObject(this.getParentIssueId());
    }

    @Override
    protected Collection getIssueTypesForProject(Project project) {
        IssueTypeSchemeManager issueTypeSchemeManager = ComponentAccessor.getIssueTypeSchemeManager();
        return issueTypeSchemeManager.getSubTaskIssueTypesForProject(project);
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

