/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.CreateIssue;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CreateIssueDetails
extends CreateIssue {
    private final IssueService issueService;
    protected IssueService.CreateValidationResult validationResult;

    public CreateIssueDetails(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean, IssueService issueService) {
        super(issueFactory, issueCreationHelperBean);
        this.issueService = issueService;
    }

    public String doInit() {
        if (this.isAbleToCreateIssueInSelectedProject()) {
            this.doValidation();
            if (this.invalidInput()) {
                return "error";
            }
        }
        return "input";
    }

    @Override
    protected void doValidation() {
        this.validationResult = this.issueService.validateCreate(this.getLoggedInUser(), new IssueInputParametersImpl(ActionContext.getParameters()));
        this.setIssueObject(this.validationResult.getIssue());
        this.fieldValuesHolder = this.validationResult.getFieldValuesHolder();
        if (!this.validationResult.isValid()) {
            ErrorCollection errorCollection = this.validationResult.getErrorCollection();
            this.transferErrorToMessages(errorCollection);
            this.addErrorCollection(errorCollection);
        }
    }

    protected void transferErrorToMessages(ErrorCollection errorCollection) {
        for (Map.Entry<String, String> entry : errorCollection.getErrors().entrySet()) {
            errorCollection.addErrorMessage(entry.getKey() + ": " + entry.getValue());
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            this.createIssue();
            if (this.hasAnyErrors()) {
                return "error";
            }
            return this.doPostCreationTasks();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(e.getMessage() != null ? e.getMessage() : ExceptionUtils.getFullStackTrace((Throwable)e));
            return "error";
        }
    }

    protected void createIssue() throws Exception {
        IssueService.IssueResult issueResult;
        if (this.validationResult == null) {
            this.validationResult = new IssueService.CreateValidationResult(this.getIssueObject(), new SimpleErrorCollection(), this.getFieldValuesHolder());
        }
        if ((issueResult = this.issueService.create(this.getLoggedInUser(), this.validationResult, this.getAuxiliarySubmitButtonValue())).isValid()) {
            this.setIssueObject(issueResult.getIssue());
        } else {
            this.addErrorCollection(issueResult.getErrorCollection());
        }
    }

    protected String doPostCreationTasks() throws Exception {
        String issueKey = JiraUrlCodec.encode(this.getKey());
        if (this.isIssueValid()) {
            return this.getRedirect("/browse/" + issueKey);
        }
        this.errorMessages.clear();
        return this.getRedirect("CantBrowseCreatedIssue.jspa?issueKey=" + issueKey);
    }

    @Override
    public GenericValue getIssue() {
        GenericValue issue = super.getIssue();
        if (issue == null) {
            throw new IllegalStateException("No issue has been created yet so it can not be retrieved");
        }
        return issue;
    }

    protected String getAuxiliarySubmitButtonValue() throws WorkflowException {
        JiraWorkflow workflow = ManagerFactory.getWorkflowManager().getWorkflow(this.getPid(), this.getIssuetype());
        if (workflow == null) {
            throw new WorkflowException("No workflow for pid " + this.getPid() + ", issuetype " + this.getIssuetype());
        }
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        List initialActions = descriptor.getInitialActions();
        if (initialActions.size() == 0) {
            throw new WorkflowException("There are no initial actions for workflow " + workflow + ", descriptor " + descriptor + " associated with pid " + this.getPid() + " and issue type " + this.getIssuetype());
        }
        Map buttons = ((ActionDescriptor)initialActions.get(0)).getMetaAttributes();
        for (String key : buttons.keySet()) {
            if (this.request.getParameter(key) == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

