/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.WebAttachmentManager;
import java.util.Iterator;
import webwork.action.ServletActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class AttachTemporaryFile
extends AbstractIssueSelectAction {
    public static final String TEMP_FILENAME = "tempFilename";
    protected final transient WebAttachmentManager webAttachmentManager;
    protected final transient IssueUpdater issueUpdater;
    protected final transient ApplicationProperties applicationProperties;
    private boolean create = false;
    private Long projectId;
    private TemporaryAttachment temporaryAttachment;

    public AttachTemporaryFile(SubTaskManager subTaskManager, WebAttachmentManager webAttachmentManager, IssueUpdater issueUpdater, ApplicationProperties applicationProperties) {
        super(subTaskManager);
        this.webAttachmentManager = webAttachmentManager;
        this.issueUpdater = issueUpdater;
        this.applicationProperties = applicationProperties;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            this.temporaryAttachment = this.isCreate() ? this.webAttachmentManager.createTemporaryAttachment(this.getMultipart(), TEMP_FILENAME, null, this.getProjectObject()) : this.webAttachmentManager.createTemporaryAttachment(this.getMultipart(), TEMP_FILENAME, this.getIssueObject(), null);
        }
        catch (AttachmentException e) {
            this.addErrorMessage(e.getMessage());
        }
        return "temp_file_json";
    }

    public TemporaryAttachment getTemporaryAttachment() {
        return this.temporaryAttachment;
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    protected MultiPartRequestWrapper getMultipart() {
        return ServletActionContext.getMultiPartRequest();
    }

    public String encode(String text) {
        return JSONEscaper.escape(text);
    }

    public Project getProjectObject() {
        if (this.projectId != null) {
            return this.getProjectManager().getProjectObj(this.projectId);
        }
        return null;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getErrorMessage() {
        if (!this.getErrorMessages().isEmpty()) {
            StringBuilder errorMsgs = new StringBuilder();
            Iterator errorIterator = this.getErrorMessages().iterator();
            while (errorIterator.hasNext()) {
                String error = (String)errorIterator.next();
                errorMsgs.append(error);
                if (!errorIterator.hasNext()) continue;
                errorMsgs.append(", ");
            }
            return errorMsgs.toString();
        }
        return "";
    }
}

