/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SequencedCollection;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class AbstractCommentableIssue
extends AbstractViewIssue
implements OperationContext {
    private String comment;
    private String groupLevel;
    private String commentLevel;
    private final Map fieldValuesHolder = new HashMap();
    private final transient FieldScreenRendererFactory fieldScreenRendererFactory;
    private final transient FieldManager fieldManager;
    private final transient ProjectRoleManager projectRoleManager;
    private final transient CommentService commentService;
    protected final transient UserUtil userUtil;
    private transient FieldScreenRenderer fieldScreenRendererWithAllFields;

    public AbstractCommentableIssue(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil) {
        super(subTaskManager);
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
        this.projectRoleManager = projectRoleManager;
        this.commentService = commentService;
        this.userUtil = userUtil;
    }

    protected void doValidation() {
        this.doCommentValidation(true);
    }

    protected void doCommentValidation(boolean allowEmptyComment) {
        OrderableField field = this.getOrderableField("comment");
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.putAll(ActionContext.getParameters());
        if (!allowEmptyComment) {
            params.put("comment.create.param", new String[]{"true"});
        }
        field.populateFromParams(this.getFieldValuesHolder(), params);
        field.validateParams(this, this, this, this.getIssueObject(), this.getFieldScreenRendererLayoutItemForField(field));
    }

    protected void populateCommentFields() {
        OrderableField field = this.getOrderableField("comment");
        HashMap params = new HashMap();
        params.putAll(ActionContext.getParameters());
        field.populateFromParams(this.getFieldValuesHolder(), params);
    }

    protected Comment createComment() {
        MutableIssue commentedIssue = this.getIssueObject();
        OrderableField commentField = this.getOrderableField("comment");
        FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(commentedIssue).getFieldLayoutItem(commentField);
        commentField.updateIssue(fieldLayoutItem, commentedIssue, this.getFieldValuesHolder());
        ModifiedValue comment = commentedIssue.getModifiedFields().get("comment");
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        if (comment != null) {
            commentField.updateValue(fieldLayoutItem, commentedIssue, comment, changeHolder);
        }
        commentedIssue.getModifiedFields().remove("comment");
        return changeHolder.getComment();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCommentLevel() {
        return this.commentLevel;
    }

    public void setCommentLevel(String commentLevel) {
        this.commentLevel = commentLevel;
    }

    public String getGroupLevel() {
        return this.groupLevel;
    }

    public void setGroupLevel(String groupLevel) {
        if (!StringUtils.isBlank((String)groupLevel) && this.getLoggedInUser() != null && ComponentAccessor.getGroupManager().isUserInGroup(this.getLoggedInUser().getName(), groupLevel) && !StringUtils.isBlank((String)groupLevel)) {
            this.groupLevel = groupLevel;
        }
    }

    public Collection getGroupLevels() {
        SequencedCollection<Object> groups = this.getLoggedInUser() == null || !this.commentService.isGroupVisiblityEnabled() ? Collections.EMPTY_LIST : this.userUtil.getGroupsForUser(this.getLoggedInUser().getName());
        return groups;
    }

    public Collection<ProjectRole> getRoleLevels() {
        Collection<ProjectRole> roleLevels = this.commentService.isProjectRoleVisiblityEnabled() ? this.projectRoleManager.getProjectRoles(this.getLoggedInUser(), this.getIssueObject().getProjectObject()) : Collections.emptyList();
        return roleLevels;
    }

    @Override
    public Map getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    @Override
    public IssueOperation getIssueOperation() {
        return IssueOperations.EDIT_ISSUE_OPERATION;
    }

    public void setFieldValuesHolder(Map fieldValuesHolder) {
        this.fieldValuesHolder.clear();
        this.fieldValuesHolder.putAll(fieldValuesHolder);
    }

    public FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(OrderableField field) {
        return this.getFieldScreenRendererWithAllFields().getFieldScreenRenderLayoutItem(field);
    }

    public Map<String, Object> getDisplayParams() {
        return Collections.emptyMap();
    }

    protected FieldScreenRenderer getFieldScreenRendererWithAllFields() {
        if (this.fieldScreenRendererWithAllFields == null) {
            this.fieldScreenRendererWithAllFields = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getLoggedInUser(), (Issue)this.getIssueObject(), (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, false);
        }
        return this.fieldScreenRendererWithAllFields;
    }

    protected OrderableField getOrderableField(String fieldId) {
        return (OrderableField)this.fieldManager.getField(fieldId);
    }
}

