/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.jira.util.SimpleToCronUtil;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.CronEditorWebComponent;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import webwork.action.ActionContext;

public class FilterSubscription
extends SearchDescriptionEnabledAction
implements FilterOperationsAction {
    private Long subId = null;
    private Long filterId = null;
    private String groupName;
    private Boolean emailOnEmpty = Boolean.FALSE;
    private Timestamp lastRun;
    private Timestamp nextRun;
    private SearchRequest searchRequest;
    private SubscriptionManager subscriptionManager = ManagerFactory.getSubscriptionManager();
    private CronEditorBean cronEditorBean;
    private final FilterSubscriptionService filterSubscriptionService;
    private final SearchRequestService searchRequestService;

    public FilterSubscription(IssueSearcherManager issueSearcherManager, FilterSubscriptionService filterSubscriptionService, SearchRequestService searchRequestService, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.filterSubscriptionService = filterSubscriptionService;
        this.searchRequestService = searchRequestService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDefault() throws Exception {
        if (this.subId == null && this.filterId == null) {
            this.addErrorMessage(this.getText("filtersubscription.please.select.a.subscription.or.filter"));
            return "error";
        }
        if (this.subId != null) {
            GenericValue subscription = this.subscriptionManager.getSubscription(this.getLoggedInUser(), this.subId);
            if (subscription == null) {
                return "permissionviolation";
            }
            this.groupName = subscription.getString("group");
            this.emailOnEmpty = Boolean.valueOf(subscription.getString("emailOnEmpty"));
            this.lastRun = subscription.getTimestamp("lastRun");
            Trigger trigger = this.subscriptionManager.getTriggerFromSubscription(subscription);
            if (trigger instanceof SimpleTrigger) {
                SimpleToCronUtil util = new SimpleToCronUtil(ManagerFactory.getScheduler(), new SimpleToCronTriggerConverter());
                boolean restartScheduler = util.pauseScheduler();
                try {
                    trigger = util.convertSimpleToCronTrigger((SimpleTrigger)trigger);
                }
                finally {
                    util.restartScheduler(restartScheduler);
                }
            }
            if (trigger instanceof CronTrigger) {
                CronTrigger cronTrigger = (CronTrigger)trigger;
                String cronExpression = cronTrigger.getCronExpression();
                CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
                this.cronEditorBean = cronExpresionParser.getCronEditorBean();
            } else {
                this.log.error((Object)("Invalid trigger (" + trigger.getClass().getName() + ") returned from subscriptionManager, expected CronTrigger as of JIRA v3.9. subScriptionId: " + this.subId));
            }
            this.nextRun = new Timestamp(trigger.getNextFireTime().getTime());
        }
        if (this.filterId != null) {
            this.searchRequest = this.searchRequestService.getFilter(this.getJiraServiceContext(), this.filterId);
            if (this.searchRequest == null) {
                return "error";
            }
        }
        return super.doDefault();
    }

    public void doValidation() {
        this.cronEditorBean = new CronEditorBean("filter.subscription.prefix", ActionContext.getParameters());
        CronEditorWebComponent component = new CronEditorWebComponent();
        this.addErrorCollection(component.validateInput(this.cronEditorBean, "cron.editor.name"));
        if (!this.hasAnyErrors()) {
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            String cronString = component.getCronExpressionFromInput(this.cronEditorBean);
            this.filterSubscriptionService.validateCronExpression(serviceContext, cronString);
        }
    }

    protected String doExecute() throws Exception {
        String cronExpression = new CronExpressionGenerator().getCronExpressionFromInput(this.cronEditorBean);
        if (this.subId != null) {
            GenericValue subscription = this.subscriptionManager.getSubscription(this.getLoggedInUser(), this.subId);
            if (subscription == null) {
                return "permissionviolation";
            }
            this.filterSubscriptionService.updateSubscription(this.getJiraServiceContext(), this.subId, this.getGroupName(), cronExpression, this.emailOnEmpty);
        } else {
            this.searchRequest = this.searchRequestService.getFilter(this.getJiraServiceContext(), this.filterId);
            if (this.searchRequest == null) {
                return "securitybreach";
            }
            this.filterSubscriptionService.storeSubscription(this.getJiraServiceContext(), this.filterId, this.getGroupName(), cronExpression, this.getEmailOnEmpty());
        }
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.filterId);
    }

    public String doDelete() throws Exception {
        GenericValue subscription = this.subscriptionManager.getSubscription(this.getLoggedInUser(), this.subId);
        if (subscription == null) {
            this.addErrorMessage(this.getText("subscriptions.error.delete.subscriptiondoesnotexist"));
            return "error";
        }
        ManagerFactory.getSubscriptionManager().deleteSubscription(this.subId);
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.filterId);
    }

    public String doRunNow() throws Exception {
        GenericValue subscription = this.subscriptionManager.getSubscription(this.getLoggedInUser(), this.subId);
        if (subscription == null) {
            this.addErrorMessage(this.getText("subscriptions.error.runnow.subscriptiondoesnotexist"));
            return "error";
        }
        ManagerFactory.getSubscriptionManager().runSubscription(this.getLoggedInUser(), this.subId);
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.filterId);
    }

    public boolean hasGroupPermission() throws GenericEntityException {
        return ManagerFactory.getPermissionManager().hasPermission(24, this.getLoggedInUser());
    }

    public String getSubmitName() throws GenericEntityException {
        if (this.subId == null) {
            return this.getText("filtersubscription.subscribe");
        }
        return this.getText("common.forms.update");
    }

    public String getCancelStr() throws GenericEntityException {
        if (this.subId == null) {
            return "ManageFilters.jspa";
        }
        return "ViewSubscriptions.jspa?filterId=" + this.filterId;
    }

    public String getFilterId() {
        if (this.filterId == null) {
            return null;
        }
        return this.filterId.toString();
    }

    public void setFilterId(String filterId) {
        if (TextUtils.stringSet((String)filterId)) {
            this.filterId = new Long(filterId);
        }
    }

    public String getSubId() {
        if (this.subId == null) {
            return null;
        }
        return this.subId.toString();
    }

    public void setSubId(String subId) {
        if (TextUtils.stringSet((String)subId)) {
            this.subId = new Long(subId);
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean getEmailOnEmpty() {
        return this.emailOnEmpty;
    }

    public void setEmailOnEmpty(Boolean emailOnEmpty) {
        this.emailOnEmpty = emailOnEmpty;
    }

    public String getLastRun() {
        if (this.lastRun == null) {
            return null;
        }
        return String.valueOf(this.lastRun.getTime());
    }

    public void setLastRun(String lastRun) {
        if (TextUtils.stringSet((String)lastRun)) {
            this.lastRun = new Timestamp(Long.parseLong(lastRun));
        }
    }

    public String getNextRun() {
        if (this.nextRun == null) {
            return null;
        }
        return String.valueOf(this.nextRun.getTime());
    }

    public void setNextRun(String nextRun) {
        if (TextUtils.stringSet((String)nextRun)) {
            this.nextRun = new Timestamp(Long.parseLong(nextRun));
        }
    }

    public String getLastRunStr() {
        if (this.lastRun == null) {
            return null;
        }
        return ManagerFactory.getOutlookDateManager().getOutlookDate(this.getLocale()).formatDMYHMS(this.lastRun);
    }

    public String getNextRunStr() {
        if (this.nextRun == null) {
            return null;
        }
        return ManagerFactory.getOutlookDateManager().getOutlookDate(this.getLocale()).formatDMYHMS(this.nextRun);
    }

    public Collection getGroups() {
        return FilterUtils.getGroups(this.getLoggedInUser());
    }

    public CronEditorBean getCronEditorBean() {
        if (this.cronEditorBean == null) {
            this.cronEditorBean = new CronExpressionParser().getCronEditorBean();
        }
        return this.cronEditorBean;
    }
}

