/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

public class DeleteFilter
extends SearchDescriptionEnabledAction {
    private final SearchRequestService searchRequestService;
    private final FilterSubscriptionService subscriptionService;
    private final FavouritesService favouriteService;
    private Long filterId;
    private SearchRequest filter;
    private Long otherFavouriteCount;
    private Collection subscriptions;

    public DeleteFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, FavouritesService favouriteService, SearchService searchService, SearchSortUtil searchSortUtil, FilterSubscriptionService subscriptionService) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.searchRequestService = searchRequestService;
        this.favouriteService = favouriteService;
        this.subscriptionService = subscriptionService;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public int getOtherFavouriteCount() {
        if (this.otherFavouriteCount == null) {
            SearchRequest request = this.getFilter();
            boolean isFavourite = this.favouriteService.isFavourite(this.getLoggedInUser(), request);
            int count = isFavourite ? request.getFavouriteCount().intValue() - 1 : request.getFavouriteCount().intValue();
            this.otherFavouriteCount = count;
        }
        return this.otherFavouriteCount.intValue();
    }

    public String getFilterName() throws GenericEntityException {
        SearchRequest filter = this.getFilter();
        return filter == null ? null : filter.getName();
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }

    public int getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    public Collection getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = this.subscriptionService.getVisibleSubscriptions(this.getLoggedInUser(), this.getFilter());
        }
        return this.subscriptions;
    }

    public boolean isUserLoggedIn() {
        return this.getLoggedInUser() != null;
    }

    public String doDefault() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.filterId != null) {
            this.searchRequestService.validateForDelete(ctx, this.filterId);
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        return "input";
    }

    public String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.filterId != null) {
            this.searchRequestService.validateForDelete(ctx, this.filterId);
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.searchRequestService.deleteFilter(ctx, this.filterId);
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        this.setSearchRequest(null);
        return this.returnComplete(this.getReturnUrl());
    }

    protected SearchRequest getFilter() {
        if (this.filter == null && this.filterId != null) {
            JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getLoggedInUser(), new SimpleErrorCollection());
            this.filter = this.searchRequestService.getFilter(ctx, this.filterId);
        }
        return this.filter;
    }
}

