/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.VersionProxy;
import com.atlassian.jira.project.util.ReleaseNoteManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class ReleaseNote
extends JiraWebActionSupport {
    private long projectId;
    private String styleName;
    private String version;
    private final ProjectManager projectManager;
    private final ReleaseNoteManager releaseNoteManager;
    private final ConstantsManager constantsManager;
    private final VersionManager versionManager;

    public ReleaseNote(ProjectManager projectManager, ReleaseNoteManager releaseNoteManager, ConstantsManager constantsManager, VersionManager versionManager) {
        this.projectManager = projectManager;
        this.releaseNoteManager = releaseNoteManager;
        this.constantsManager = constantsManager;
        this.versionManager = versionManager;
    }

    public Collection getVersions() throws GenericEntityException {
        Project project = this.projectManager.getProjectObj(this.projectId);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<VersionProxy> unreleased = new ArrayList<VersionProxy>();
        Iterator<Version> unreleasedIter = this.versionManager.getVersionsUnreleased(project.getId(), false).iterator();
        if (unreleasedIter.hasNext()) {
            unreleased.add(new VersionProxy(-2L, this.getText("common.filters.unreleasedversions")));
            while (unreleasedIter.hasNext()) {
                unreleased.add(new VersionProxy(unreleasedIter.next()));
            }
        }
        ArrayList<VersionProxy> released = new ArrayList<VersionProxy>();
        ArrayList<Version> releasedIter = new ArrayList<Version>(this.versionManager.getVersionsReleased(project.getId(), false));
        if (!releasedIter.isEmpty()) {
            released.add(new VersionProxy(-3L, this.getText("common.filters.releasedversions")));
            Collections.reverse(releasedIter);
            Iterator iterator = releasedIter.iterator();
            while (iterator.hasNext()) {
                released.add(new VersionProxy((Version)iterator.next()));
            }
        }
        ArrayList<VersionProxy> versions = new ArrayList<VersionProxy>();
        versions.addAll(unreleased);
        versions.addAll(released);
        return versions;
    }

    public Collection getStyleNames() {
        return this.releaseNoteManager.getStyles().keySet();
    }

    public String getReleaseNote() {
        return this.releaseNoteManager.getReleaseNote((Action)this, this.getStyleName(), this.getSelectedVersion(), this.getLoggedInUser(), this.getProjectGV());
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        GenericValue project = this.projectManager.getProjectByName(projectName);
        if (project != null) {
            this.projectId = project.getLong("id");
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionName(String versionName) {
        Version versionObj = this.versionManager.getVersion(this.getProjectId(), versionName);
        if (versionObj != null) {
            this.version = "" + versionObj.getId();
        }
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public long getProjectId() {
        return this.projectId;
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.version) || "-1".equals(this.version) || "-2".equals(this.version) || "-3".equals(this.version)) {
            this.addError("version", this.getText("releasenotes.version.select"));
        } else if (this.getProjectGV() == null) {
            this.addError("version", this.getText("releasenotes.project.error"));
        } else if (this.getSelectedVersion() == null) {
            this.addError("version", this.getText("releasenotes.version.error"));
        }
    }

    protected String doExecute() throws GenericEntityException {
        return this.getResult();
    }

    public String doConfigure() throws GenericEntityException {
        if (this.getProjectGV() == null || this.getVersions().isEmpty() || this.getStyleNames().isEmpty()) {
            return "error";
        }
        return "success";
    }

    private Version getSelectedVersion() {
        try {
            return this.versionManager.getVersion(Long.parseLong(this.getVersion()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private GenericValue getProjectGV() {
        return this.projectManager.getProject(this.getProjectId());
    }

    public Collection getIssueTypes() throws GenericEntityException {
        return this.constantsManager.getIssueTypes();
    }
}

