/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.TabPanelModuleDescriptor;
import com.atlassian.jira.plugin.browsepanel.TabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContextImpl;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanel;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.util.PopularIssueTypesUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import webwork.action.ActionContext;

public class BrowseVersion
extends JiraWebActionSupport {
    private List<VersionTabPanelModuleDescriptor> versionTabPanels;
    private Long versionId;
    private BrowseVersionContext versionContext;
    private final PluginAccessor pluginAccessor;
    private final WebResourceManager webResourceManager;
    private final ProjectManager projectManager;
    private final PopularIssueTypesUtil popularIssueTypesUtil;
    private final PermissionManager permissionManager;
    private Collection<IssueType> popularIssueTypes;
    private Collection<IssueType> otherIssueTypes;
    private boolean contentOnly = false;
    private boolean noTitle = false;
    private static final String NO_TITLE = "noTitle";
    private boolean stateUpdateOnly;
    private ProjectTabPanelModuleDescriptor projectTab;
    private Long projectId;

    public BrowseVersion(PluginAccessor pluginAccessor, WebResourceManager webResourceManager, PopularIssueTypesUtil popularIssueTypesUtil, ProjectManager projectManager, PermissionManager permissionManager) {
        this.pluginAccessor = pluginAccessor;
        this.webResourceManager = webResourceManager;
        this.popularIssueTypesUtil = popularIssueTypesUtil;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    protected String doExecute() {
        Version version;
        Project newProject;
        Project project = this.getSelectedProjectObject();
        if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
            this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
            return "permissionviolation";
        }
        if (project == null) {
            return this.getRedirect("/secure/BrowseProjects.jspa");
        }
        if (this.versionId != null && (version = this.getVersionManager().getVersion(this.versionId)) != null && version.getProjectObject().getId().equals(project.getId())) {
            if (!this.contentOnly) {
                this.webResourceManager.requireResource("jira.webresources:ajaxhistory");
                this.webResourceManager.requireResource("jira.webresources:browseproject");
            }
            if (this.stateUpdateOnly) {
                return "stateupdate";
            }
            if (this.contentOnly) {
                return "contentonly";
            }
            return "success";
        }
        return this.getRedirect("/browse/" + project.getKey());
    }

    public boolean hasCreateIssuePermissionForProject() {
        return this.permissionManager.hasPermission(11, this.getProject(), this.getLoggedInUser());
    }

    public String getTabHtmlForJSON() throws IOException {
        String tabPanelHTML = this.getTabHtml();
        return JSONEscaper.escape(tabPanelHTML);
    }

    public String getTabHtml() throws IOException {
        String selectedTab = this.getSelected();
        if (selectedTab == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        ModuleDescriptor tabPanelDescriptor = this.pluginAccessor.getEnabledPluginModule(selectedTab);
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + selectedTab + "' has been specified."));
            return "";
        }
        if (!(tabPanelDescriptor instanceof VersionTabPanelModuleDescriptor)) {
            this.log.warn((Object)("Incorrect plugin module type '" + selectedTab + "' has been specified."));
            return "";
        }
        VersionTabPanel panel = (VersionTabPanel)tabPanelDescriptor.getModule();
        if (panel.showPanel(this.getVersionContext())) {
            boolean descriptorNoTitle;
            String tabHtml = panel.getHtml(this.getVersionContext());
            StringBuilder strBuilder = new StringBuilder();
            if (this.isContentOnly()) {
                SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
                this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
                strBuilder.append(writer.toString());
            }
            boolean bl = descriptorNoTitle = tabPanelDescriptor.getParams().containsKey(NO_TITLE) && "true".equalsIgnoreCase((String)tabPanelDescriptor.getParams().get(NO_TITLE));
            if (!this.isNoTitle() && !descriptorNoTitle) {
                strBuilder.append("<h2>");
                strBuilder.append(this.getTabLabel());
                strBuilder.append("</h2>\n");
            }
            strBuilder.append(tabHtml);
            return strBuilder.toString();
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    public String getTabLabel() {
        String selectedTab = this.getSelected();
        if (selectedTab == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        VersionTabPanelModuleDescriptor tabPanelDescriptor = (VersionTabPanelModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(selectedTab);
        return tabPanelDescriptor.getLabel();
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public void setVersionId(Long id) {
        this.versionId = id;
        this.versionContext = null;
    }

    public Project getProject() {
        return this.getSelectedProjectObject();
    }

    public BrowseVersionContext getVersionContext() {
        if (this.versionContext == null) {
            this.versionContext = new BrowseVersionContextImpl(this.getVersion(), this.getLoggedInUser());
        }
        return this.versionContext;
    }

    public List<VersionTabPanelModuleDescriptor> getVersionTabPanels() {
        if (this.versionTabPanels == null) {
            this.versionTabPanels = this.initTabPanels(VersionTabPanelModuleDescriptor.class);
        }
        return this.versionTabPanels;
    }

    public String getSelected() {
        String currentKey = (String)ActionContext.getSession().get("jira.version.browser.selected");
        if (this.canSeeTab(currentKey)) {
            return currentKey;
        }
        List<VersionTabPanelModuleDescriptor> tabPanels = this.getVersionTabPanels();
        if (!tabPanels.isEmpty()) {
            String key = tabPanels.get(0).getCompleteKey();
            ActionContext.getSession().put("jira.version.browser.selected", key);
            return key;
        }
        return null;
    }

    private boolean canSeeTab(String tabKey) {
        if (tabKey == null) {
            return false;
        }
        List<VersionTabPanelModuleDescriptor> tabPanels = this.getVersionTabPanels();
        StringTokenizer st = new StringTokenizer(tabKey, ":");
        if (st.countTokens() == 2) {
            st.nextToken();
            String tabName = st.nextToken();
            for (VersionTabPanelModuleDescriptor descriptor : tabPanels) {
                if (tabName == null || !tabName.equals(descriptor.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectedTab(String report) {
        ActionContext.getSession().put("jira.version.browser.selected", report);
    }

    protected boolean isTabPanelHidden(TabPanelModuleDescriptor<? extends TabPanel> descriptor) throws PermissionException {
        return !((TabPanel)descriptor.getModule()).showPanel(this.getVersionContext());
    }

    protected List<VersionTabPanelModuleDescriptor> initTabPanels(Class tabPanelClass) {
        ArrayList<VersionTabPanelModuleDescriptor> tabPanels;
        try {
            tabPanels = new ArrayList<VersionTabPanelModuleDescriptor>(this.pluginAccessor.getEnabledModuleDescriptorsByClass(tabPanelClass));
            Iterator iterator = tabPanels.iterator();
            while (iterator.hasNext()) {
                VersionTabPanelModuleDescriptor descriptor = (VersionTabPanelModuleDescriptor)iterator.next();
                if (!this.isTabPanelHidden(descriptor)) continue;
                iterator.remove();
            }
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(tabPanels, ModuleDescriptorComparator.COMPARATOR);
        return tabPanels;
    }

    public Version getVersion() {
        return this.versionId == null ? null : this.getVersionManager().getVersion(this.versionId);
    }

    public NextPreviousVersion getNextAndPreviousVersions() {
        Version currentVersion = this.getVersion();
        if (currentVersion != null) {
            Collection<Version> versions = this.getVersionManager().getVersionsUnarchived(currentVersion.getProjectObject().getId());
            Version previous = null;
            Version next = null;
            Iterator<Version> versionIterator = versions.iterator();
            while (versionIterator.hasNext()) {
                Version version = versionIterator.next();
                if (version.equals(currentVersion)) {
                    if (versionIterator.hasNext()) {
                        next = versionIterator.next();
                    }
                    return new NextPreviousVersion(previous, next);
                }
                previous = version;
            }
        }
        return new NextPreviousVersion(null, null);
    }

    public boolean isHasProjectAdminPermission() {
        return this.permissionManager.hasPermission(23, this.getProject(), this.getLoggedInUser());
    }

    public Collection<IssueType> getPopularIssueTypes() {
        if (this.popularIssueTypes == null) {
            this.popularIssueTypes = this.popularIssueTypesUtil.getPopularIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.popularIssueTypes;
    }

    public Collection<IssueType> getOtherIssueTypes() {
        if (this.otherIssueTypes == null) {
            this.otherIssueTypes = this.popularIssueTypesUtil.getOtherIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.otherIssueTypes;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isStateUpdateOnly() {
        return this.stateUpdateOnly;
    }

    public void setStateUpdateOnly(boolean stateUpdateOnly) {
        this.stateUpdateOnly = stateUpdateOnly;
    }

    public boolean isNoTitle() {
        return this.noTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    private ProjectTabPanelModuleDescriptor getSelectedProjectTab() {
        String currentKey;
        if (this.projectTab == null && (currentKey = (String)ActionContext.getSession().get("jira.project.browser.report")) != null) {
            this.projectTab = (ProjectTabPanelModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(currentKey);
        }
        return this.projectTab;
    }

    public String getBrowseProjectTabLabel() {
        ProjectTabPanelModuleDescriptor browseProjectTab = this.getSelectedProjectTab();
        if (browseProjectTab == null) {
            return this.getText("common.concepts.summary");
        }
        return browseProjectTab.getLabel();
    }

    public String getBrowseProjectTabKey() {
        ProjectTabPanelModuleDescriptor browseProjectTab = this.getSelectedProjectTab();
        if (browseProjectTab == null) {
            return "com.atlassian.jira.plugin.system.project:summary-panel";
        }
        return browseProjectTab.getCompleteKey();
    }

    public static class NextPreviousVersion {
        private final Version next;
        private final Version previous;

        public NextPreviousVersion(Version previous, Version next) {
            this.next = next;
            this.previous = previous;
        }

        public Version getNext() {
            return this.next;
        }

        public Version getPrevious() {
            return this.previous;
        }
    }
}

