/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.bonfire;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import java.lang.reflect.Method;
import java.util.Arrays;

public class SetupBonfire
extends JiraWebActionSupport {
    private static final String COM_ATLASSIAN_BONFIRE_PLUGIN = "com.atlassian.bonfire.plugin";
    private static final String BONFIRE_LICENSE_KEY = "bonfire-license";
    private static final String KEY_EX_PROPS = "Excalibur.properties";
    private static final long GLOBAL_ENTITY_ID = 1L;
    private final ExternalLinkUtil externalLinkUtil;
    private final PluginAccessor pluginAccessor;
    private final JiraLicenseService licenseService;
    private final PluginController pluginController;
    private String license;

    public SetupBonfire(ExternalLinkUtil externalLinkUtil, PluginAccessor pluginAccessor, JiraLicenseService licenseService, PluginController pluginController) {
        this.externalLinkUtil = externalLinkUtil;
        this.pluginAccessor = pluginAccessor;
        this.licenseService = licenseService;
        this.pluginController = pluginController;
    }

    public String doFetchLicense() throws Exception {
        return "input";
    }

    public String doReturnFromMAC() throws Exception {
        return "input";
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        super.doValidation();
    }

    private JiraLicenseService getLicenseService() {
        return ComponentManager.getComponent(JiraLicenseService.class);
    }

    protected String doExecute() throws Exception {
        ErrorCollection errorCollection = this.invokeBonfireSetLicence();
        if (errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
            return "error";
        }
        return this.getRedirect("/secure/MyJiraHome.jspa");
    }

    private ErrorCollection invokeBonfireSetLicence() throws Exception {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Plugin plugin = this.pluginAccessor.getPlugin(COM_ATLASSIAN_BONFIRE_PLUGIN);
        if (plugin == null) {
            errorCollection.addErrorMessage("setup.bonfire.no.plugin");
        } else {
            this.pluginController.enablePlugins(new String[]{COM_ATLASSIAN_BONFIRE_PLUGIN});
            ModuleDescriptor moduleDescriptor = plugin.getModuleDescriptor("bonfire-license-service");
            if (moduleDescriptor == null) {
                errorCollection.addErrorMessage(this.getText("setup.bonfire.no.licence.module"));
            } else {
                Object bonfireLicenceService = moduleDescriptor.getModule();
                Method validateAndSetLicence = bonfireLicenceService.getClass().getMethod("validateAndSetLicence", ErrorCollection.class, String.class);
                validateAndSetLicence.invoke(bonfireLicenceService, errorCollection, this.getLicense());
            }
        }
        return errorCollection;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getRequestLicenseURL() {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl(this.request));
        url.append("/secure/SetupBonfire!returnFromMAC.jspa");
        String version = this.pluginAccessor.getPlugin(COM_ATLASSIAN_BONFIRE_PLUGIN).getPluginInformation().getVersion();
        String organisation = this.licenseService.getLicense().getOrganisation();
        return this.externalLinkUtil.getProperty("external.link.bonfire.license.view", Arrays.asList(version, "Atlassian Bonfire : Evaluation", this.getServerId(), organisation, url.toString()));
    }
}

