/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.web.action.admin.workflow.scheme.SchemeAwareWorkflowAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteWorkflowSchemeEntity
extends SchemeAwareWorkflowAction {
    private Long id;
    private boolean confirmed = false;
    private final WorkflowManager workflowManager;

    public DeleteWorkflowSchemeEntity(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    protected void doValidation() {
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.workflows.specify.scheme.entity"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.workflows.confirm.deletion"));
        }
    }

    protected String doExecute() throws Exception {
        this.getSchemeManager().deleteEntity(this.getId());
        if (this.getSchemeId() == null) {
            return this.returnComplete("ViewWorkflowSchemes.jspa");
        }
        return this.returnCompleteWithInlineRedirect("EditWorkflowSchemeEntities!default.jspa?schemeId=" + this.getSchemeId());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GenericValue getWorkflowSchemeEntity() throws GenericEntityException {
        return this.getSchemeManager().getEntity(this.id);
    }

    public JiraWorkflow getWorkflow() throws GenericEntityException {
        return this.workflowManager.getWorkflow(this.getWorkflowSchemeEntity().getString("workflow"));
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    public String getRedirectURL() {
        return null;
    }
}

