/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowStep;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class ViewWorkflowSteps
extends AbstractWorkflowStep {
    private final ProjectWorkflowSchemeHelper helper;
    private List<Project> projects;

    public ViewWorkflowSteps(JiraWorkflow workflow, ConstantsManager constantsManager, WorkflowService workflowService, ProjectWorkflowSchemeHelper helper) {
        super(workflow, constantsManager, workflowService);
        this.helper = helper;
    }

    @RequiresXsrfCheck
    public String doAddStep() throws Exception {
        if (StringUtils.isNotBlank((String)this.getStepName())) {
            List existingSteps = this.getWorkflow().getDescriptor().getSteps();
            for (StepDescriptor existingStep : existingSteps) {
                if (this.getStepName().equalsIgnoreCase(existingStep.getName())) {
                    this.addError("stepName", this.getText("admin.errors.step.with.name.already.exists"));
                }
                if (!this.getStepStatus().equalsIgnoreCase((String)existingStep.getMetaAttributes().get("jira.status.id"))) continue;
                this.addError("stepStatus", this.getText("admin.errors.existing.step.already.linked"));
            }
        } else {
            this.addError("stepName", this.getText("admin.errors.step.name.must.be.specified"));
        }
        if (!this.invalidInput()) {
            StepDescriptor newStep = DescriptorFactory.getFactory().createStepDescriptor();
            newStep.setName(this.getStepName());
            newStep.setId(WorkflowUtil.getNextId(this.getWorkflow().getDescriptor().getSteps()));
            newStep.getMetaAttributes().put("jira.status.id", this.getStepStatus());
            newStep.setParent((AbstractDescriptor)this.getWorkflow().getDescriptor());
            this.getWorkflow().getDescriptor().addStep(newStep);
            this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        }
        return "success";
    }

    public boolean isTransitionWithoutStepChange(ActionDescriptor transition) {
        return transition.getUnconditionalResult().getStep() == -1;
    }

    public Status getStatus(String id) {
        return this.getConstantsManager().getStatusObject(id);
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            JiraWorkflow workflow = this.getWorkflow();
            this.projects = this.helper.getProjectsForWorkflow(workflow.getName());
        }
        return this.projects;
    }
}

