/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;

@WebSudoRequired
public class CloneWorkflow
extends JiraWebActionSupport {
    private final JiraWorkflow workflow;
    private final WorkflowService workflowService;
    private String description;
    private String newWorkflowName;

    public CloneWorkflow(JiraWorkflow workflow, WorkflowService workflowService) {
        this.workflow = workflow;
        this.workflowService = workflowService;
    }

    public String doDefault() throws Exception {
        this.newWorkflowName = WorkflowUtil.cloneWorkflowName(this.getWorkflow().getName());
        if (TextUtils.stringSet((String)this.getWorkflow().getDescription())) {
            this.setDescription(this.getWorkflow().getDescription());
        }
        return super.doDefault();
    }

    protected void doValidation() {
        this.workflowService.validateCopyWorkflow(this.getJiraServiceContext(), this.newWorkflowName);
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.workflowService.copyWorkflow(this.getJiraServiceContext(), this.newWorkflowName, this.getDescription(), this.getWorkflow());
        return this.returnComplete("ListWorkflows.jspa");
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }
}

