/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewUserProjectRoles
extends JiraWebActionSupport {
    protected ProjectManager projectManager;
    protected ProjectRoleService projectRoleService;
    protected ProjectFactory projectFactory;
    private CrowdService crowdService;
    protected String name;
    private HashMap<Long, List<Project>> projectsByCategory;
    protected Collection<Project> currentVisibleProjects;
    private Collection<ProjectRole> projectRoles;
    private Map<GenericValue, List<Project>> visibleProjectsByCategory;
    private User projectRoleEditUser;
    private Map<Long, List<Long>> projectsUserInForByProjectRole;
    private ProjectRoleGroupsProjectMapper projectRoleGroupsProjectMapper;

    public ViewUserProjectRoles(ProjectManager projectManager, ProjectRoleService projectRoleService, ProjectFactory projectFactory, CrowdService crowdService) {
        this.projectManager = projectManager;
        this.projectRoleService = projectRoleService;
        this.projectFactory = projectFactory;
        this.crowdService = crowdService;
    }

    public Collection<ProjectRole> getAllProjectRoles() {
        if (this.projectRoles == null) {
            this.projectRoles = this.projectRoleService.getProjectRoles(this.getLoggedInUser(), this);
        }
        return this.projectRoles;
    }

    public Collection<GenericValue> getAllProjectCategories() {
        return this.projectManager.getProjectCategories();
    }

    public Collection getAllProjectsForCategory(GenericValue projectCategory) {
        List<Project> projects = this.getProjectsByCategory().get(projectCategory.getLong("id"));
        if (projects == null) {
            projects = this.projectFactory.getProjects(this.projectManager.getProjectsFromProjectCategory(projectCategory));
            this.getProjectsByCategory().put(projectCategory.getLong("id"), projects);
        }
        return projects;
    }

    public boolean isUserInProjectRoleTypeUser(ProjectRole projectRole, Project project) {
        List<Long> projectsUserInForProjectRole;
        if (this.projectsUserInForByProjectRole == null) {
            this.projectsUserInForByProjectRole = Maps.newHashMap();
        }
        if ((projectsUserInForProjectRole = this.projectsUserInForByProjectRole.get(projectRole.getId())) == null) {
            projectsUserInForProjectRole = this.projectRoleService.roleActorOfTypeExistsForProjects(this.getLoggedInUser(), this.getVisibleProjectIds(), projectRole, "atlassian-user-role-actor", this.name, this);
            this.projectsUserInForByProjectRole.put(projectRole.getId(), projectsUserInForProjectRole);
        }
        return projectsUserInForProjectRole.contains(project.getId());
    }

    public String getUserInProjectRoleOtherType(ProjectRole projectRole, Project project) {
        return this.getRoleMapper().getGroupNameString(projectRole, project);
    }

    public boolean isRoleForProjectSelected(ProjectRole role, Project project) {
        String paramKey;
        String paramKeyOrig;
        Map parameters = ActionContext.getParameters();
        if (parameters.containsKey(paramKeyOrig = (paramKey = project.getId() + "_" + role.getId()) + "_orig")) {
            String[] newValueParam = (String[])parameters.get(paramKey);
            return newValueParam != null;
        }
        return this.isUserInProjectRoleTypeUser(role, project);
    }

    public Collection<Project> getCurrentVisibleProjects() {
        if (this.currentVisibleProjects == null) {
            this.currentVisibleProjects = this.getRoleMapper().getProjects();
        }
        return this.currentVisibleProjects;
    }

    private ProjectRoleGroupsProjectMapper getRoleMapper() {
        if (this.projectRoleGroupsProjectMapper == null) {
            this.projectRoleGroupsProjectMapper = new ProjectRoleGroupsProjectMapper();
        }
        return this.projectRoleGroupsProjectMapper;
    }

    public Map getVisibleProjectsByCategory() {
        if (this.visibleProjectsByCategory == null) {
            this.visibleProjectsByCategory = new TreeMap<GenericValue, List<Project>>(OfBizComparators.NAME_COMPARATOR);
            for (Project project : this.getCurrentVisibleProjects()) {
                ArrayList projects = this.visibleProjectsByCategory.get(project.getProjectCategory());
                if (projects == null) {
                    projects = Lists.newArrayList();
                    this.visibleProjectsByCategory.put(project.getProjectCategory(), projects);
                }
                projects.add(project);
            }
            for (List list : this.visibleProjectsByCategory.values()) {
                Collections.sort(list, ProjectNameComparator.COMPARATOR);
            }
        }
        return this.visibleProjectsByCategory;
    }

    public int getProjectRoleColumnWidth() {
        return 75 / this.getAllProjectRoles().size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User getProjectRoleEditUser() {
        if (this.projectRoleEditUser == null) {
            this.projectRoleEditUser = this.crowdService.getUser(this.name);
        }
        return this.projectRoleEditUser;
    }

    private List<Long> getVisibleProjectIds() {
        ArrayList visibleProjectIds = Lists.newArrayList();
        for (Project project : this.getCurrentVisibleProjects()) {
            visibleProjectIds.add(project.getId());
        }
        return visibleProjectIds;
    }

    private HashMap<Long, List<Project>> getProjectsByCategory() {
        if (this.projectsByCategory == null) {
            this.projectsByCategory = Maps.newHashMap();
        }
        return this.projectsByCategory;
    }

    public String doDefault() throws Exception {
        super.doDefault();
        User user = this.getProjectRoleEditUser();
        if (user == null) {
            this.addErrorMessage("No user exists");
            return "error";
        }
        return "success";
    }

    @Override
    public String getReturnUrl() {
        String returnUrl = super.getReturnUrl();
        if (StringUtils.isEmpty((String)returnUrl)) {
            return "ViewUser.jspa";
        }
        return returnUrl;
    }

    private class ProjectRoleGroupsProjectMapper {
        private final Map roleProjectMap;
        private final Set<Project> projects;

        ProjectRoleGroupsProjectMapper() {
            this.roleProjectMap = new HashMap(ViewUserProjectRoles.this.getAllProjectRoles().size());
            this.projects = Sets.newHashSet();
            HashSet ids = Sets.newHashSet();
            for (ProjectRole projectRole : ViewUserProjectRoles.this.getAllProjectRoles()) {
                List<Long> projectIds = ViewUserProjectRoles.this.currentVisibleProjects == null ? Collections.emptyList() : this.getCurrentVisibleProjectIds();
                Map<Long, List<String>> groupsByProject = ViewUserProjectRoles.this.projectRoleService.getProjectIdsForUserInGroupsBecauseOfRole(ViewUserProjectRoles.this.getLoggedInUser(), projectIds, projectRole, "atlassian-group-role-actor", ViewUserProjectRoles.this.name, ViewUserProjectRoles.this);
                this.roleProjectMap.put(projectRole.getId(), groupsByProject);
                ids.addAll(groupsByProject.keySet());
            }
            if (!ids.isEmpty()) {
                this.projects.addAll(ViewUserProjectRoles.this.projectFactory.getProjects(ViewUserProjectRoles.this.projectManager.convertToProjects(ids)));
            }
            this.projects.addAll(ViewUserProjectRoles.this.projectRoleService.getProjectsContainingRoleActorByNameAndType(ViewUserProjectRoles.this.getLoggedInUser(), ViewUserProjectRoles.this.name, "atlassian-user-role-actor", ViewUserProjectRoles.this));
        }

        private List<Long> getCurrentVisibleProjectIds() {
            ArrayList currentVisibleProjectIds = Lists.newArrayList();
            for (Project project : ViewUserProjectRoles.this.currentVisibleProjects) {
                currentVisibleProjectIds.add(project.getId());
            }
            return currentVisibleProjectIds;
        }

        String getGroupNameString(ProjectRole projectRole, Project project) {
            Collection groupNamesUserInForProject = this.getGroupNames(projectRole.getId(), project.getId());
            if (groupNamesUserInForProject != null && !groupNamesUserInForProject.isEmpty()) {
                return this.getListAsString(groupNamesUserInForProject);
            }
            return null;
        }

        Collection getGroupNames(Long roleId, Long projectId) {
            Map groupNamesByProject = (Map)this.roleProjectMap.get(roleId);
            if (groupNamesByProject == null) {
                return Collections.emptyList();
            }
            return (Collection)groupNamesByProject.get(projectId);
        }

        Collection<Project> getProjects() {
            return this.projects;
        }

        String getListAsString(Collection groupNamesUserInForProject) {
            StringBuilder groups = new StringBuilder();
            Iterator iterator = groupNamesUserInForProject.iterator();
            while (iterator.hasNext()) {
                groups.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                groups.append(", ");
            }
            return groups.toString();
        }
    }
}

