/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.core.util.StringUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.filter.SearchRequestAdminService;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.security.util.GroupToIssueSecuritySchemeMapper;
import com.atlassian.jira.security.util.GroupToNotificationSchemeMapper;
import com.atlassian.jira.security.util.GroupToPermissionSchemeMapper;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewGroup
extends JiraWebActionSupport {
    private String name;
    private Group group;
    private GroupToPermissionSchemeMapper groupPermissionSchemeMapper;
    private GroupToNotificationSchemeMapper groupNotificationSchemeMapper;
    private GroupToIssueSecuritySchemeMapper groupIssueSecuritySchemeMapper;
    private final SearchRequestAdminService searchRequestService;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final UserFormatManager userFormatManager;
    private CrowdService crowdService;

    public ViewGroup(SearchRequestAdminService searchRequestManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, UserFormatManager userFormatManager, PermissionSchemeManager permissionSchemeManager, SchemePermissions schemePermissions, NotificationSchemeManager notificationSchemeManager, CrowdService crowdService) throws GenericEntityException {
        this.searchRequestService = searchRequestManager;
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.userFormatManager = userFormatManager;
        this.crowdService = crowdService;
        this.groupPermissionSchemeMapper = new GroupToPermissionSchemeMapper(permissionSchemeManager, schemePermissions);
        this.groupNotificationSchemeMapper = new GroupToNotificationSchemeMapper(notificationSchemeManager);
        IssueSecuritySchemeManager securitySchemeManager = ComponentManager.getComponentInstanceOfType(IssueSecuritySchemeManager.class);
        IssueSecurityLevelManager securityLevelManager = ComponentManager.getComponentInstanceOfType(IssueSecurityLevelManager.class);
        try {
            this.groupIssueSecuritySchemeMapper = new GroupToIssueSecuritySchemeMapper(securitySchemeManager, securityLevelManager);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String execute() {
        this.group = this.crowdService.getGroup(this.getName());
        if (this.group == null) {
            this.addErrorMessage("Group not found.");
        }
        return this.getResult();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Group getGroup() {
        return this.group;
    }

    public Collection getPermissionSchemes(String groupName) {
        if (this.groupPermissionSchemeMapper != null) {
            return this.groupPermissionSchemeMapper.getMappedValues(groupName);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getNotificationSchemes(String groupName) {
        if (this.groupNotificationSchemeMapper != null) {
            return this.groupNotificationSchemeMapper.getMappedValues(groupName);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getIssueSecuritySchemes(String groupName) {
        if (this.groupIssueSecuritySchemeMapper != null) {
            return this.groupIssueSecuritySchemeMapper.getMappedValues(groupName);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getSavedFilters(Group group) {
        Collection filters = this.searchRequestService.getFiltersSharedWithGroup(group);
        return filters == null ? Collections.EMPTY_LIST : filters;
    }

    public String getEscapeAmpersand(String str) {
        return StringUtils.replaceAll((String)str, (String)"&", (String)"%26");
    }

    public boolean isUserAbleToDeleteGroup(String groupName) {
        return this.globalPermissionGroupAssociationUtil.isUserAbleToDeleteGroup(this.getLoggedInUser(), groupName);
    }

    public String getFullUserName(String userName) {
        if (userName != null) {
            return this.userFormatManager.formatUser(userName, "fullName", "view_group");
        }
        return null;
    }
}

