/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.bean.UserBrowserFilter;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;
import webwork.util.BeanUtil;

@WebSudoRequired
public class UserBrowser
extends AbstractBrowser {
    private List<User> users;
    private final UserUtil userUtil;
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final UserManager userManager;
    private final AvatarService avatarService;

    public UserBrowser(UserUtil userUtil, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserManager userManager, AvatarService avatarService) {
        this.userUtil = userUtil;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userManager = userManager;
        this.avatarService = avatarService;
    }

    protected String doExecute() throws Exception {
        String emailFilterParam = this.getSingleParam("emailFilter");
        String groupParam = this.getSingleParam("group");
        String maxUsersPerPage = this.getSingleParam("max");
        if ("".equals(emailFilterParam) || "".equals(groupParam)) {
            this.resetPager();
            this.setStart("0");
        }
        BeanUtil.setProperties((Map)this.params, (Object)this.getFilter());
        if (TextUtils.stringSet((String)maxUsersPerPage)) {
            this.getFilter().setMax(Integer.parseInt(maxUsersPerPage));
        }
        if (this.getBrowsableItems().size() <= this.getPager().getStart()) {
            this.setStart("0");
        }
        return super.doExecute();
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.user.filter", null);
    }

    public UserBrowserFilter getFilter() {
        UserBrowserFilter filter = (UserBrowserFilter)ActionContext.getSession().get("jira.user.filter");
        if (filter == null) {
            filter = new UserBrowserFilter(this.getLocale());
            ActionContext.getSession().put("jira.user.filter", filter);
        }
        return filter;
    }

    @Override
    public List<User> getCurrentPage() {
        return this.getFilter().getCurrentPage(this.getBrowsableItems());
    }

    @Override
    public List<User> getBrowsableItems() {
        if (this.users == null) {
            try {
                this.users = this.getFilter().getFilteredUsers();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting users: " + e), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.users;
    }

    public Iterator getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        return this.crowdService.search((Query)query).iterator();
    }

    public Iterator getGroupsForUser(User user) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery).iterator();
    }

    public String getDirectoryForUser(User user) {
        return this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName();
    }

    public Collection<User> getUsers() {
        return this.getBrowsableItems();
    }

    public boolean isRemoteUserPermittedToEditSelectedUser(User user) {
        if (this.userManager.canUpdateUser(user)) {
            return user != null && (this.isSystemAdministrator() || !this.getGlobalPermissionManager().hasPermission(44, user));
        }
        return false;
    }

    public boolean isRemoteUserPermittedToEditSelectedUsersGroups(User user) {
        return this.userManager.canUpdateGroupMembershipForUser(user);
    }

    public UserUtil getUserUtil() {
        return this.userUtil;
    }

    public boolean hasReachedUserLimit() {
        return !this.userUtil.canActivateNumberOfUsers(1);
    }

    public URI getAvatarUrl(String username) {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), username, Avatar.Size.SMALL);
    }
}

