/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.core.util.StringUtils;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.util.GroupToPermissionSchemeMapper;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.GroupBrowserFilter;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;
import webwork.util.BeanUtil;

@WebSudoRequired
public class GroupBrowser
extends AbstractBrowser {
    private List groups;
    private String addName;
    private GroupToPermissionSchemeMapper groupPermissionSchemeMapper;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final CrowdService crowdService;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private Boolean hasGroupWritableDirectory = null;

    public GroupBrowser(GroupToPermissionSchemeMapper groupToPermissionSchemeMapper, UserManager userManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, GroupManager groupManager) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.groupManager = groupManager;
        this.userManager = userManager;
        if (groupToPermissionSchemeMapper != null) {
            this.groupPermissionSchemeMapper = groupToPermissionSchemeMapper;
        } else {
            this.addErrorMessage(this.getText("groupbrowser.error.retrieve.group"));
        }
    }

    public GroupBrowser(GroupManager groupManager, UserManager userManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil) throws GenericEntityException {
        this(new GroupToPermissionSchemeMapper(ComponentAccessor.getPermissionSchemeManager(), ComponentAccessor.getComponent(SchemePermissions.class)), userManager, globalPermissionGroupAssociationUtil, crowdService, crowdDirectoryService, groupManager);
    }

    protected String doExecute() throws Exception {
        this.resetPager();
        BeanUtil.setProperties((Map)this.params, (Object)this.getFilter());
        return "success";
    }

    @RequiresXsrfCheck
    public String doAdd() throws Exception {
        if (!this.addNewGroup()) {
            return "error";
        }
        return this.doExecute();
    }

    private boolean addNewGroup() {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)this.addName)) {
            this.addError("addName", this.getText("admin.errors.cannot.add.groups.invalid.group.name"));
            return false;
        }
        if (!this.userManager.hasGroupWritableDirectory()) {
            this.addErrorMessage(this.getText("admin.errors.cannot.add.groups.directories.read.only"));
            return false;
        }
        if (this.crowdService.getGroup(this.addName) == null) {
            try {
                this.crowdService.addGroup((Group)new ImmutableGroup(this.addName));
            }
            catch (OperationNotPermittedException e) {
                this.addError("addName", this.getText("groupbrowser.error.add", this.addName));
                this.log.error((Object)("Error occurred adding group : " + this.addName), (Throwable)e);
            }
            catch (InvalidGroupException e) {
                this.addError("addName", this.getText("groupbrowser.error.add", this.addName));
                this.log.error((Object)("Error occurred adding group : " + this.addName), (Throwable)e);
            }
            catch (OperationFailedException e) {
                this.addError("addName", this.getText("groupbrowser.error.add", this.addName));
                this.log.error((Object)("Error occurred adding group : " + this.addName), (Throwable)e);
            }
            this.addName = null;
        } else {
            this.addError("addName", this.getText("groupbrowser.error.group.exists"));
        }
        return true;
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.group.filter", null);
    }

    public GroupBrowserFilter getFilter() {
        GroupBrowserFilter filter = (GroupBrowserFilter)ActionContext.getSession().get("jira.group.filter");
        if (filter == null) {
            filter = new GroupBrowserFilter();
            ActionContext.getSession().put("jira.group.filter", filter);
        }
        return filter;
    }

    @Override
    public List getCurrentPage() {
        return this.getFilter().getCurrentPage(this.getBrowsableItems());
    }

    @Override
    public List getBrowsableItems() {
        if (this.groups == null) {
            try {
                this.groups = this.getFilter().getFilteredGroups();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting groups: " + e), (Throwable)e);
                return Collections.EMPTY_LIST;
            }
        }
        return this.groups;
    }

    public String getAddName() {
        return this.addName;
    }

    public void setAddName(String addName) {
        this.addName = addName.trim();
    }

    public String escapeAmpersand(String str) {
        return StringUtils.replaceAll((String)str, (String)"&", (String)"%26");
    }

    public Collection<User> getUsersForGroup(Group group) {
        return this.groupManager.getUsersInGroup(group);
    }

    public Collection getPermissionSchemes(String groupName) {
        if (this.groupPermissionSchemeMapper != null) {
            return this.groupPermissionSchemeMapper.getMappedValues(groupName);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasGroupWritableDirectory() {
        if (this.hasGroupWritableDirectory == null) {
            this.hasGroupWritableDirectory = new Boolean(this.userManager.hasGroupWritableDirectory());
        }
        return this.hasGroupWritableDirectory;
    }

    public boolean isUserAbleToDeleteGroup(String groupName) {
        return this.globalPermissionGroupAssociationUtil.isUserAbleToDeleteGroup(this.getLoggedInUser(), groupName);
    }

    public boolean isNestedGroupsEnabledForAnyDirectory() {
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (!this.crowdDirectoryService.supportsNestedGroups(directory.getId().longValue())) continue;
            return true;
        }
        return false;
    }
}

