/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.user.UserProperty;
import org.apache.commons.lang.StringUtils;

public class EditUserProperty
extends UserProperty {
    public EditUserProperty(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
    }

    @Override
    protected String doExecute() throws Exception {
        if (this.key != null) {
            this.setValue(this.userPropertyManager.getPropertySet(this.getUser()).getString(this.getTrueKey()));
        }
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doUpdate() {
        if (StringUtils.isBlank((String)this.value)) {
            this.addError("value", this.getText("admin.errors.userproperty.value.empty"));
        } else if (this.value.length() > 250) {
            this.addError("value", this.getText("admin.errors.userproperty.value.too.long"));
        }
        if (this.invalidInput()) {
            this.retrieveUserMetaProperties();
            return "error";
        }
        this.userPropertyManager.getPropertySet(this.getUser()).setString(this.getTrueKey(), this.value);
        return this.redirectToView();
    }

    private String redirectToView() {
        return this.getRedirect("EditUserProperties.jspa?name=" + JiraUrlCodec.encode(this.getName()));
    }
}

