/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.user.UserProperty;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class EditUserProperties
extends UserProperty {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z0-9\\s]+");

    public EditUserProperties(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
    }

    @Override
    protected String doExecute() throws Exception {
        this.retrieveUserMetaProperties();
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doAdd() {
        this.validateUserInput();
        if (this.hasAnyErrors()) {
            this.retrieveUserMetaProperties();
            return "error";
        }
        this.userPropertyManager.getPropertySet(this.getUser()).setString(this.getTrueKey(), this.value);
        return this.redirectToView();
    }

    private void validateUserInput() {
        if (this.getUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.users.user.does.not.exist"));
            return;
        }
        if (StringUtils.isBlank((String)this.value)) {
            this.addError("value", this.getText("admin.errors.userproperties.value.empty"));
        } else if (this.value.length() > 250) {
            this.addError("value", this.getText("admin.errors.userproperties.value.too.long"));
        }
        if (StringUtils.isBlank((String)this.key)) {
            this.addError("key", this.getText("admin.errors.userproperties.key.empty"));
        } else if (!PATTERN.matcher(this.key).matches()) {
            this.addError("key", this.getText("admin.errors.userproperties.key.cannot.use.special.characters"));
        } else if (this.key.length() > 200) {
            this.addError("key", this.getText("admin.errors.userproperties.key.too.long"));
        } else {
            PropertySet ps = this.userPropertyManager.getPropertySet(this.getUser());
            if (ps.getString(this.getTrueKey()) != null) {
                this.addError("key", this.getText("admin.errors.userproperties.key.already.exists"));
            }
        }
    }

    private String redirectToView() {
        return this.getRedirect("EditUserProperties.jspa?name=" + JiraUrlCodec.encode(this.getName()));
    }
}

